/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.netconf.util;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.sal.connect.netconf.util.NetconfMessageTransformUtil;
import org.opendaylight.netconf.sal.connect.netconf.util.RpcStructureTransformer;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SchemalessRpcStructureTransformer
implements RpcStructureTransformer {
    SchemalessRpcStructureTransformer() {
    }

    @Override
    public Optional<NormalizedNode<?, ?>> selectFromDataStructure(DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?> data, YangInstanceIdentifier path) {
        Preconditions.checkArgument((boolean)(data instanceof AnyXmlNode));
        List<XmlElement> xmlElements = SchemalessRpcStructureTransformer.selectMatchingNodes(SchemalessRpcStructureTransformer.getSourceElement(((AnyXmlNode)data).getValue()), path);
        Document result = XmlUtil.newDocument();
        Element dataElement = result.createElementNS(NetconfMessageTransformUtil.NETCONF_DATA_QNAME.getNamespace().toString(), NetconfMessageTransformUtil.NETCONF_DATA_QNAME.getLocalName());
        result.appendChild(dataElement);
        for (XmlElement xmlElement : xmlElements) {
            dataElement.appendChild(result.importNode(xmlElement.getDomElement(), true));
        }
        AnyXmlNode resultAnyxml = (AnyXmlNode)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DATA_NODEID).withValue((Object)new DOMSource(result)).build();
        return Optional.of(resultAnyxml);
    }

    @Override
    public AnyXmlNode createEditConfigStructure(Optional<NormalizedNode<?, ?>> data, YangInstanceIdentifier dataPath, Optional<ModifyAction> operation) {
        Element parentXmlStructure;
        Preconditions.checkArgument((boolean)data.isPresent());
        Preconditions.checkArgument((boolean)(data.get() instanceof AnyXmlNode));
        AnyXmlNode anxmlData = (AnyXmlNode)data.get();
        Document document = XmlUtil.newDocument();
        Element dataNode = (Element)document.importNode(SchemalessRpcStructureTransformer.getSourceElement(anxmlData.getValue()), true);
        SchemalessRpcStructureTransformer.checkDataValidForPath(dataPath, dataNode);
        Element configElement = document.createElementNS(NetconfMessageTransformUtil.NETCONF_CONFIG_QNAME.getNamespace().toString(), NetconfMessageTransformUtil.NETCONF_CONFIG_QNAME.getLocalName());
        document.appendChild(configElement);
        if (dataPath.equals((Object)YangInstanceIdentifier.EMPTY)) {
            parentXmlStructure = dataNode;
            configElement.appendChild(parentXmlStructure);
        } else {
            List pathArguments = dataPath.getPathArguments();
            List<YangInstanceIdentifier.PathArgument> pathWithoutLast = pathArguments.subList(0, pathArguments.size() - 1);
            parentXmlStructure = SchemalessRpcStructureTransformer.instanceIdToXmlStructure(pathWithoutLast, configElement);
        }
        if (operation.isPresent()) {
            SchemalessRpcStructureTransformer.setOperationAttribute(operation, document, dataNode);
        }
        parentXmlStructure.appendChild(document.importNode(dataNode, true));
        return (AnyXmlNode)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_CONFIG_NODEID).withValue((Object)new DOMSource(document.getDocumentElement())).build();
    }

    @Override
    public DataContainerChild<?, ?> toFilterStructure(YangInstanceIdentifier path) {
        Document document = XmlUtil.newDocument();
        QName filterQname = NetconfMessageTransformUtil.NETCONF_FILTER_QNAME;
        Element filter = document.createElementNS(filterQname.getNamespace().toString(), filterQname.getLocalName());
        Attr a = document.createAttributeNS(filterQname.getNamespace().toString(), "type");
        a.setTextContent("subtree");
        filter.setAttributeNode(a);
        document.appendChild(filter);
        SchemalessRpcStructureTransformer.instanceIdToXmlStructure(path.getPathArguments(), filter);
        return (DataContainerChild)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(filterQname)).withValue((Object)new DOMSource(document.getDocumentElement())).build();
    }

    private static void checkDataValidForPath(YangInstanceIdentifier dataPath, Element dataNode) {
        if (dataPath.equals((Object)YangInstanceIdentifier.EMPTY)) {
            return;
        }
        XmlElement dataElement = XmlElement.fromDomElement((Element)dataNode);
        YangInstanceIdentifier.PathArgument lastPathArgument = dataPath.getLastPathArgument();
        QName nodeType = lastPathArgument.getNodeType();
        if (!nodeType.getNamespace().toString().equals(dataNode.getNamespaceURI()) || !nodeType.getLocalName().equals(dataElement.getName())) {
            throw new IllegalStateException(String.format("Can't write data '%s' to path %s", dataNode.getTagName(), dataPath));
        }
        if (lastPathArgument instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            SchemalessRpcStructureTransformer.checkKeyValuesValidForPath(dataElement, lastPathArgument);
        }
    }

    private static void checkKeyValuesValidForPath(XmlElement dataElement, YangInstanceIdentifier.PathArgument lastPathArgument) {
        YangInstanceIdentifier.NodeIdentifierWithPredicates keyedId = (YangInstanceIdentifier.NodeIdentifierWithPredicates)lastPathArgument;
        Map keyValues = keyedId.getKeyValues();
        for (Map.Entry entry : keyValues.entrySet()) {
            String textContent;
            QName qualifiedName = (QName)entry.getKey();
            List key = dataElement.getChildElementsWithinNamespace(qualifiedName.getLocalName(), qualifiedName.getNamespace().toString());
            if (key.isEmpty()) {
                throw new IllegalStateException("No key present in xml");
            }
            if (key.size() > 1) {
                throw new IllegalStateException("Multiple values for same key present");
            }
            try {
                textContent = ((XmlElement)key.get(0)).getTextContent();
            }
            catch (DocumentedException e) {
                throw new IllegalStateException("Key value not present in key element", e);
            }
            if (entry.getValue().equals(textContent)) continue;
            throw new IllegalStateException("Key value in path not equal to key value in xml");
        }
    }

    private static void setOperationAttribute(Optional<ModifyAction> operation, Document document, Element dataNode) {
        QName operationQname = NetconfMessageTransformUtil.NETCONF_OPERATION_QNAME;
        Attr operationAttribute = document.createAttributeNS(operationQname.getNamespace().toString(), operationQname.getLocalName());
        operationAttribute.setTextContent(SchemalessRpcStructureTransformer.toOperationString(operation.get()));
        dataNode.setAttributeNode(operationAttribute);
    }

    private static Element instanceIdToXmlStructure(List<YangInstanceIdentifier.PathArgument> pathArguments, Element data) {
        Document doc = data.getOwnerDocument();
        Element parent = data;
        for (YangInstanceIdentifier.PathArgument pathArgument : pathArguments) {
            QName nodeType = pathArgument.getNodeType();
            Element element = doc.createElementNS(nodeType.getNamespace().toString(), nodeType.getLocalName());
            parent.appendChild(element);
            if (pathArgument instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                YangInstanceIdentifier.NodeIdentifierWithPredicates listNode = (YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArgument;
                for (Map.Entry key : listNode.getKeyValues().entrySet()) {
                    Element keyElement = doc.createElementNS(((QName)key.getKey()).getNamespace().toString(), ((QName)key.getKey()).getLocalName());
                    keyElement.setTextContent(key.getValue().toString());
                    element.appendChild(keyElement);
                }
            }
            parent = element;
        }
        return parent;
    }

    private static List<XmlElement> selectMatchingNodes(Element domElement, YangInstanceIdentifier path) {
        XmlElement element = XmlElement.fromDomElement((Element)domElement);
        for (YangInstanceIdentifier.PathArgument pathArgument : path.getPathArguments()) {
            List childElements = element.getChildElements(pathArgument.getNodeType().getLocalName());
            if (childElements.size() == 1) {
                element = (XmlElement)childElements.get(0);
                continue;
            }
            return childElements;
        }
        return Collections.singletonList(element);
    }

    private static String toOperationString(ModifyAction operation) {
        return operation.name().toLowerCase(Locale.ROOT);
    }

    private static Element getSourceElement(DOMSource source) {
        Node node = source.getNode();
        switch (node.getNodeType()) {
            case 9: {
                return ((Document)node).getDocumentElement();
            }
            case 1: {
                return (Element)node;
            }
        }
        throw new IllegalStateException("DOMSource node must be document or element.");
    }
}

