/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.CreateDeviceInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.CreateDeviceOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.CreateDeviceOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.DeleteDeviceInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.DeleteDeviceOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.DeleteDeviceOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeTopologyService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPw;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPwBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.login.pw.LoginPassword;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.login.pw.LoginPasswordBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfTopologyRPCProvider
implements NetconfNodeTopologyService {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfTopologyRPCProvider.class);
    private final InstanceIdentifier<Topology> topologyPath;
    private final AAAEncryptionService encryptionService;
    private final DataBroker dataBroker;

    public NetconfTopologyRPCProvider(DataBroker dataBroker, AAAEncryptionService encryptionService, String topologyId) {
        this.dataBroker = dataBroker;
        this.encryptionService = (AAAEncryptionService)Preconditions.checkNotNull((Object)encryptionService);
        this.topologyPath = InstanceIdentifier.builder(NetworkTopology.class).child(Topology.class, (Identifier)new TopologyKey(new TopologyId((String)Preconditions.checkNotNull((Object)topologyId)))).build();
    }

    @Override
    public ListenableFuture<RpcResult<CreateDeviceOutput>> createDevice(CreateDeviceInput input) {
        NetconfNode node = this.encryptPassword(input);
        SettableFuture futureResult = SettableFuture.create();
        NodeId nodeId = new NodeId(input.getNodeId());
        this.writeToConfigDS(node, nodeId, (SettableFuture<RpcResult<CreateDeviceOutput>>)futureResult);
        return futureResult;
    }

    @VisibleForTesting
    public NetconfNode encryptPassword(CreateDeviceInput input) {
        NetconfNodeBuilder builder = new NetconfNodeBuilder();
        builder.fieldsFrom(input);
        Credentials credentials = this.handleEncryption(input.getCredentials());
        builder.setCredentials(credentials);
        return builder.build();
    }

    private Credentials handleEncryption(Credentials credentials) {
        if (credentials instanceof LoginPw) {
            LoginPassword loginPassword = ((LoginPw)credentials).getLoginPassword();
            String encryptedPassword = this.encryptionService.encrypt(loginPassword.getPassword());
            return new LoginPwBuilder().setLoginPassword(new LoginPasswordBuilder().setPassword(encryptedPassword).setUsername(loginPassword.getUsername()).build()).build();
        }
        return credentials;
    }

    private void writeToConfigDS(NetconfNode node, NodeId nodeId, final SettableFuture<RpcResult<CreateDeviceOutput>> futureResult) {
        WriteTransaction writeTransaction = this.dataBroker.newWriteOnlyTransaction();
        InstanceIdentifier niid = this.topologyPath.child(Node.class, (Identifier)new NodeKey(nodeId)).augmentation(NetconfNode.class);
        writeTransaction.merge(LogicalDatastoreType.CONFIGURATION, niid, (DataObject)node, true);
        writeTransaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.info("add-netconf-node RPC: Added netconf node successfully.");
                futureResult.set((Object)RpcResultBuilder.success((Object)new CreateDeviceOutputBuilder().build()).build());
            }

            public void onFailure(Throwable exception) {
                LOG.error("add-netconf-node RPC: Unable to add netconf node.", exception);
                futureResult.setException(exception);
            }
        }, MoreExecutors.directExecutor());
    }

    @Override
    public ListenableFuture<RpcResult<DeleteDeviceOutput>> deleteDevice(DeleteDeviceInput input) {
        NodeId nodeId = new NodeId(input.getNodeId());
        KeyedInstanceIdentifier niid = this.topologyPath.child(Node.class, (Identifier)new NodeKey(nodeId));
        WriteTransaction wtx = this.dataBroker.newWriteOnlyTransaction();
        wtx.delete(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)niid);
        final SettableFuture rpcFuture = SettableFuture.create();
        wtx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.info("delete-device RPC: Removed netconf node successfully.");
                rpcFuture.set((Object)RpcResultBuilder.success((Object)new DeleteDeviceOutputBuilder().build()).build());
            }

            public void onFailure(Throwable exception) {
                LOG.error("delete-device RPC: Unable to remove netconf node.", exception);
                rpcFuture.setException(exception);
            }
        }, MoreExecutors.directExecutor());
        return rpcFuture;
    }
}

