/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.connect.util;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.HostBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.network.topology.topology.topology.types.TopologyNetconf;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public final class RemoteDeviceId {
    private static final String DEFAULT_TOPOLOGY_NAME = TopologyNetconf.QNAME.getLocalName();
    private static final KeyedInstanceIdentifier<Topology, TopologyKey> DEFAULT_TOPOLOGY_IID = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Identifier)new TopologyKey(new TopologyId(DEFAULT_TOPOLOGY_NAME)));
    private static final YangInstanceIdentifier DEFAULT_TOPOLOGY_NODE = YangInstanceIdentifier.builder().node(NetworkTopology.QNAME).node(Topology.QNAME).nodeWithKey(Topology.QNAME, QName.create((QName)Topology.QNAME, (String)"topology-id"), (Object)DEFAULT_TOPOLOGY_NAME).node(Node.QNAME).build();
    private static final QName NODE_ID_QNAME = QName.create((QName)Node.QNAME, (String)"node-id").intern();
    private final String name;
    private final NodeKey key;
    private final YangInstanceIdentifier topologyPath;
    private final KeyedInstanceIdentifier<Node, NodeKey> topologyBindingPath;
    private InetSocketAddress address;
    private Host host;

    private RemoteDeviceId(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.topologyPath = DEFAULT_TOPOLOGY_NODE.node((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifierWithPredicates(Node.QNAME, NODE_ID_QNAME, (Object)name));
        this.key = new NodeKey(new NodeId(name));
        this.topologyBindingPath = DEFAULT_TOPOLOGY_IID.child(Node.class, (Identifier)this.key);
    }

    public RemoteDeviceId(String name, InetSocketAddress address) {
        this(name);
        this.address = address;
        this.host = this.buildHost();
    }

    private Host buildHost() {
        return HostBuilder.getDefaultInstance((String)this.address.getHostString());
    }

    public String getName() {
        return this.name;
    }

    public NodeKey getBindingKey() {
        return this.key;
    }

    public InstanceIdentifier<Node> getTopologyBindingPath() {
        return this.topologyBindingPath;
    }

    public YangInstanceIdentifier getTopologyPath() {
        return this.topologyPath;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public Host getHost() {
        return this.host;
    }

    public String toString() {
        return "RemoteDevice{" + this.name + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RemoteDeviceId)) {
            return false;
        }
        RemoteDeviceId that = (RemoteDeviceId)obj;
        return this.name.equals(that.name) && this.topologyBindingPath.equals(that.topologyBindingPath);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.topologyBindingPath);
    }
}

