/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.KeystoreEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.PrivateKeys;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.TrustedCertificates;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017._private.keys.PrivateKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.keystore.entry.KeyCredential;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.trusted.certificates.TrustedCertificate;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class KeystoreBuilder
implements Builder<Keystore> {
    private List<KeyCredential> _keyCredential;
    private List<PrivateKey> _privateKey;
    private List<TrustedCertificate> _trustedCertificate;
    Map<Class<? extends Augmentation<Keystore>>, Augmentation<Keystore>> augmentation = Collections.emptyMap();

    public KeystoreBuilder() {
    }

    public KeystoreBuilder(PrivateKeys arg) {
        this._privateKey = arg.getPrivateKey();
    }

    public KeystoreBuilder(KeystoreEntry arg) {
        this._keyCredential = arg.getKeyCredential();
    }

    public KeystoreBuilder(TrustedCertificates arg) {
        this._trustedCertificate = arg.getTrustedCertificate();
    }

    public KeystoreBuilder(Keystore base) {
        Map aug;
        this._keyCredential = base.getKeyCredential();
        this._privateKey = base.getPrivateKey();
        this._trustedCertificate = base.getTrustedCertificate();
        if (base instanceof KeystoreImpl) {
            KeystoreImpl impl = (KeystoreImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Keystore>>, Augmentation<Keystore>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Keystore>>, Augmentation<Keystore>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PrivateKeys) {
            this._privateKey = ((PrivateKeys)arg).getPrivateKey();
            isValidArg = true;
        }
        if (arg instanceof TrustedCertificates) {
            this._trustedCertificate = ((TrustedCertificates)arg).getTrustedCertificate();
            isValidArg = true;
        }
        if (arg instanceof KeystoreEntry) {
            this._keyCredential = ((KeystoreEntry)arg).getKeyCredential();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.PrivateKeys, org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.TrustedCertificates, org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev171017.KeystoreEntry]");
    }

    public List<KeyCredential> getKeyCredential() {
        return this._keyCredential;
    }

    public List<PrivateKey> getPrivateKey() {
        return this._privateKey;
    }

    public List<TrustedCertificate> getTrustedCertificate() {
        return this._trustedCertificate;
    }

    public <E$$ extends Augmentation<Keystore>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public KeystoreBuilder setKeyCredential(List<KeyCredential> values) {
        this._keyCredential = values;
        return this;
    }

    public KeystoreBuilder setPrivateKey(List<PrivateKey> values) {
        this._privateKey = values;
        return this;
    }

    public KeystoreBuilder setTrustedCertificate(List<TrustedCertificate> values) {
        this._trustedCertificate = values;
        return this;
    }

    public KeystoreBuilder addAugmentation(Class<? extends Augmentation<Keystore>> augmentationType, Augmentation<Keystore> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Keystore>>, Augmentation<Keystore>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public KeystoreBuilder removeAugmentation(Class<? extends Augmentation<Keystore>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Keystore build() {
        return new KeystoreImpl(this);
    }

    private static final class KeystoreImpl
    implements Keystore {
        private final List<KeyCredential> _keyCredential;
        private final List<PrivateKey> _privateKey;
        private final List<TrustedCertificate> _trustedCertificate;
        private Map<Class<? extends Augmentation<Keystore>>, Augmentation<Keystore>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        KeystoreImpl(KeystoreBuilder base) {
            this._keyCredential = base.getKeyCredential();
            this._privateKey = base.getPrivateKey();
            this._trustedCertificate = base.getTrustedCertificate();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Keystore> getImplementedInterface() {
            return Keystore.class;
        }

        @Override
        public List<KeyCredential> getKeyCredential() {
            return this._keyCredential;
        }

        @Override
        public List<PrivateKey> getPrivateKey() {
            return this._privateKey;
        }

        @Override
        public List<TrustedCertificate> getTrustedCertificate() {
            return this._trustedCertificate;
        }

        public <E$$ extends Augmentation<Keystore>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._keyCredential);
            result = 31 * result + Objects.hashCode(this._privateKey);
            result = 31 * result + Objects.hashCode(this._trustedCertificate);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Keystore.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Keystore other = (Keystore)obj;
            if (!Objects.equals(this._keyCredential, other.getKeyCredential())) {
                return false;
            }
            if (!Objects.equals(this._privateKey, other.getPrivateKey())) {
                return false;
            }
            if (!Objects.equals(this._trustedCertificate, other.getTrustedCertificate())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                KeystoreImpl otherImpl = (KeystoreImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Keystore>>, Augmentation<Keystore>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Keystore");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_keyCredential", this._keyCredential);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_privateKey", this._privateKey);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_trustedCertificate", this._trustedCertificate);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

