/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.schema.storage;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.schema.storage.YangLibrary;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class YangLibraryBuilder
implements Builder<YangLibrary> {
    private String _password;
    private String _username;
    private Uri _yangLibraryUrl;
    Map<Class<? extends Augmentation<YangLibrary>>, Augmentation<YangLibrary>> augmentation = Collections.emptyMap();

    public YangLibraryBuilder() {
    }

    public YangLibraryBuilder(YangLibrary base) {
        Map aug;
        this._password = base.getPassword();
        this._username = base.getUsername();
        this._yangLibraryUrl = base.getYangLibraryUrl();
        if (base instanceof YangLibraryImpl) {
            YangLibraryImpl impl = (YangLibraryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<YangLibrary>>, Augmentation<YangLibrary>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<YangLibrary>>, Augmentation<YangLibrary>>(aug);
        }
    }

    public String getPassword() {
        return this._password;
    }

    public String getUsername() {
        return this._username;
    }

    public Uri getYangLibraryUrl() {
        return this._yangLibraryUrl;
    }

    public <E$$ extends Augmentation<YangLibrary>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public YangLibraryBuilder setPassword(String value) {
        this._password = value;
        return this;
    }

    public YangLibraryBuilder setUsername(String value) {
        this._username = value;
        return this;
    }

    public YangLibraryBuilder setYangLibraryUrl(Uri value) {
        this._yangLibraryUrl = value;
        return this;
    }

    public YangLibraryBuilder addAugmentation(Class<? extends Augmentation<YangLibrary>> augmentationType, Augmentation<YangLibrary> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<YangLibrary>>, Augmentation<YangLibrary>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public YangLibraryBuilder removeAugmentation(Class<? extends Augmentation<YangLibrary>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public YangLibrary build() {
        return new YangLibraryImpl(this);
    }

    private static final class YangLibraryImpl
    implements YangLibrary {
        private final String _password;
        private final String _username;
        private final Uri _yangLibraryUrl;
        private Map<Class<? extends Augmentation<YangLibrary>>, Augmentation<YangLibrary>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        YangLibraryImpl(YangLibraryBuilder base) {
            this._password = base.getPassword();
            this._username = base.getUsername();
            this._yangLibraryUrl = base.getYangLibraryUrl();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<YangLibrary> getImplementedInterface() {
            return YangLibrary.class;
        }

        @Override
        public String getPassword() {
            return this._password;
        }

        @Override
        public String getUsername() {
            return this._username;
        }

        @Override
        public Uri getYangLibraryUrl() {
            return this._yangLibraryUrl;
        }

        public <E$$ extends Augmentation<YangLibrary>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._password);
            result = 31 * result + Objects.hashCode(this._username);
            result = 31 * result + Objects.hashCode(this._yangLibraryUrl);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!YangLibrary.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            YangLibrary other = (YangLibrary)obj;
            if (!Objects.equals(this._password, other.getPassword())) {
                return false;
            }
            if (!Objects.equals(this._username, other.getUsername())) {
                return false;
            }
            if (!Objects.equals(this._yangLibraryUrl, other.getYangLibraryUrl())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                YangLibraryImpl otherImpl = (YangLibraryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<YangLibrary>>, Augmentation<YangLibrary>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"YangLibrary");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_password", (Object)this._password);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_username", (Object)this._username);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_yangLibraryUrl", (Object)this._yangLibraryUrl);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

