/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.authenticator;

import java.nio.charset.Charset;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.ShiroException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.subject.Subject;
import org.jolokia.osgi.security.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODLAuthenticator
implements Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(ODLAuthenticator.class);

    public boolean authenticate(HttpServletRequest httpServletRequest) {
        String authorization = httpServletRequest.getHeader("Authorization");
        LOG.trace("Incoming Jolokia authentication attempt: {}", (Object)authorization);
        if (authorization == null || !authorization.startsWith("Basic")) {
            return false;
        }
        try {
            String base64Creds = authorization.substring("Basic".length()).trim();
            String credentials = new String(Base64.getDecoder().decode(base64Creds), Charset.forName("UTF-8"));
            String[] values = credentials.split(":", 2);
            UsernamePasswordToken upt = new UsernamePasswordToken();
            upt.setUsername(values[0]);
            upt.setPassword(values[1].toCharArray());
            try {
                return this.login(upt);
            }
            catch (UnknownSessionException e) {
                LOG.debug("Couldn't log in {} - logging out and retrying...", (Object)upt, (Object)e);
                this.logout();
                return this.login(upt);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.trace("Formatting issue with basic auth credentials: {}", (Object)authorization, (Object)e);
            return false;
        }
    }

    private void logout() {
        Subject subject = SecurityUtils.getSubject();
        try {
            subject.logout();
            Session session = subject.getSession(false);
            if (session != null) {
                session.stop();
            }
        }
        catch (ShiroException e) {
            LOG.debug("Couldn't log out {}", (Object)subject, (Object)e);
        }
    }

    private boolean login(UsernamePasswordToken upt) {
        Subject subject = SecurityUtils.getSubject();
        try {
            subject.login((AuthenticationToken)upt);
            return true;
        }
        catch (AuthenticationException e) {
            LOG.trace("Couldn't authenticate the subject: {}", (Object)subject, (Object)e);
            return false;
        }
    }
}

