/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.datastore.h2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.aaa.datastore.h2.ConnectionProvider;
import org.opendaylight.aaa.datastore.h2.StoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"})
abstract class AbstractStore<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStore.class);
    private final String tableName;
    private final ConnectionProvider dbConnectionFactory;
    public static final String[] TABLE_TYPES = new String[]{"TABLE"};

    protected AbstractStore(ConnectionProvider dbConnectionFactory, String tableName) {
        this.dbConnectionFactory = dbConnectionFactory;
        this.tableName = tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection dbConnect() throws StoreException {
        Connection conn = this.dbConnectionFactory.getConnection();
        try {
            AbstractStore abstractStore = this;
            synchronized (abstractStore) {
                block30: {
                    DatabaseMetaData dbm = conn.getMetaData();
                    try (ResultSet rs = dbm.getTables(null, null, this.tableName, TABLE_TYPES);){
                        if (rs.next()) {
                            LOG.debug("Table {} already exists", (Object)this.tableName);
                            break block30;
                        }
                        LOG.info("Table {} does not exist, creating it", (Object)this.tableName);
                        try (Statement stmt = conn.createStatement();){
                            stmt.executeUpdate(this.getTableCreationStatement());
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            LOG.error("Error connecting to the H2 database", e);
            throw new StoreException("Cannot connect to database server", e);
        }
        return conn;
    }

    public void dbClean() throws StoreException {
        try (Connection c = this.dbConnect();){
            String sql = "DELETE FROM " + this.tableName;
            try (Statement statement = c.createStatement();){
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            LOG.error("Error clearing table {}", (Object)this.tableName, (Object)e);
            throw new StoreException("Error clearing table " + this.tableName, e);
        }
    }

    protected abstract String getTableCreationStatement();

    protected List<T> listAll() throws StoreException {
        ArrayList<T> result = new ArrayList<T>();
        String query = "SELECT * FROM " + this.tableName;
        try (Connection conn = this.dbConnect();
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            while (rs.next()) {
                result.add(this.fromResultSet(rs));
            }
        }
        catch (SQLException e) {
            LOG.error("Error listing all items from {}", (Object)this.tableName, (Object)e);
            throw new StoreException(e);
        }
        return result;
    }

    protected List<T> listFromStatement(PreparedStatement ps) throws StoreException {
        ArrayList<T> result = new ArrayList<T>();
        try (ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.fromResultSet(rs));
            }
        }
        catch (SQLException e) {
            LOG.error("Error listing matching items from {}", (Object)this.tableName, (Object)e);
            throw new StoreException(e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T firstFromStatement(PreparedStatement ps) throws StoreException {
        try (ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                T t = this.fromResultSet(rs);
                return t;
            }
            T t = null;
            return t;
        }
        catch (SQLException e) {
            LOG.error("Error listing first matching item from {}", (Object)this.tableName, (Object)e);
            throw new StoreException(e);
        }
    }

    protected abstract T fromResultSet(ResultSet var1) throws SQLException;
}

