/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.datastore.h2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.opendaylight.aaa.api.IDMStoreUtil;
import org.opendaylight.aaa.api.model.User;
import org.opendaylight.aaa.api.model.Users;
import org.opendaylight.aaa.api.password.service.PasswordHash;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.datastore.h2.AbstractStore;
import org.opendaylight.aaa.datastore.h2.ConnectionProvider;
import org.opendaylight.aaa.datastore.h2.StoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserStore
extends AbstractStore<User> {
    private static final Logger LOG = LoggerFactory.getLogger(UserStore.class);
    public static final String SQL_ID = "userid";
    public static final String SQL_DOMAIN_ID = "domainid";
    public static final String SQL_NAME = "name";
    public static final String SQL_EMAIL = "email";
    public static final String SQL_PASSWORD = "password";
    public static final String SQL_DESCR = "description";
    public static final String SQL_ENABLED = "enabled";
    public static final String SQL_SALT = "salt";
    private static final String TABLE_NAME = "USERS";
    private final PasswordHashService passwordService;

    public UserStore(ConnectionProvider dbConnectionFactory, PasswordHashService passwordService) {
        super(dbConnectionFactory, TABLE_NAME);
        this.passwordService = Objects.requireNonNull(passwordService);
    }

    @Override
    protected String getTableCreationStatement() {
        return "CREATE TABLE users (userid    VARCHAR(128) PRIMARY KEY,name       VARCHAR(128)      NOT NULL, domainid   VARCHAR(128)      NOT NULL, email      VARCHAR(128)      NOT NULL, password   VARCHAR(128)      NOT NULL, description VARCHAR(128)     NOT NULL, salt        VARCHAR(128)      NOT NULL, enabled     INTEGER          NOT NULL)";
    }

    @Override
    protected User fromResultSet(ResultSet rs) throws SQLException {
        User user = new User();
        try {
            user.setUserid(rs.getString(SQL_ID));
            user.setDomainid(rs.getString(SQL_DOMAIN_ID));
            user.setName(rs.getString(SQL_NAME));
            user.setEmail(rs.getString(SQL_EMAIL));
            user.setPassword(rs.getString(SQL_PASSWORD));
            user.setDescription(rs.getString(SQL_DESCR));
            user.setEnabled(rs.getInt(SQL_ENABLED) == 1);
            user.setSalt(rs.getString(SQL_SALT));
        }
        catch (SQLException sqle) {
            LOG.error("SQL Exception: ", sqle);
            throw sqle;
        }
        return user;
    }

    public Users getUsers() throws StoreException {
        Users users = new Users();
        users.setUsers(this.listAll());
        return users;
    }

    protected Users getUsers(String username, String domain) throws StoreException {
        LOG.debug("getUsers for: {} in domain {}", (Object)username, (Object)domain);
        Users users = new Users();
        try (Connection conn = this.dbConnect();
             PreparedStatement pstmt = conn.prepareStatement("SELECT * FROM USERS WHERE userid = ? ");){
            pstmt.setString(1, IDMStoreUtil.createUserid(username, domain));
            LOG.debug("query string: {}", (Object)pstmt.toString());
            users.setUsers(this.listFromStatement(pstmt));
        }
        catch (SQLException s) {
            throw new StoreException("SQL Exception : " + s);
        }
        return users;
    }

    /*
     * Exception decompiling
     */
    public User getUser(String id) throws StoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected User createUser(User user) throws StoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public User putUser(User user) throws StoreException {
        User savedUser = this.getUser(user.getUserid());
        if (savedUser == null) {
            return null;
        }
        if (user.getDescription() != null) {
            savedUser.setDescription(user.getDescription());
        }
        if (user.getName() != null) {
            savedUser.setName(user.getName());
        }
        if (user.isEnabled() != null) {
            savedUser.setEnabled(user.isEnabled());
        }
        if (user.getEmail() != null) {
            savedUser.setEmail(user.getEmail());
        }
        if (user.getPassword() != null) {
            String salt = user.getSalt();
            if (salt == null) {
                salt = savedUser.getSalt();
            }
            PasswordHash passwordHash = this.passwordService.getPasswordHash(user.getPassword(), salt);
            savedUser.setPassword(passwordHash.getHashedPassword());
        }
        String query = "UPDATE users SET email = ?, password = ?, description = ?, enabled = ? WHERE userid = ?";
        try (Connection conn = this.dbConnect();
             PreparedStatement statement = conn.prepareStatement(query);){
            statement.setString(1, savedUser.getEmail());
            statement.setString(2, savedUser.getPassword());
            statement.setString(3, savedUser.getDescription());
            statement.setInt(4, savedUser.isEnabled() != false ? 1 : 0);
            statement.setString(5, savedUser.getUserid());
            statement.executeUpdate();
        }
        catch (SQLException s) {
            throw new StoreException("SQL Exception : " + s);
        }
        return savedUser;
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"})
    protected User deleteUser(String userid) throws StoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

