/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.filters;

import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODLHttpAuthenticationFilter
extends BasicHttpAuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ODLHttpAuthenticationFilter.class);
    protected static final String BEARER_SCHEME = "bearer";
    protected static final String OPTIONS_HEADER = "OPTIONS";

    public ODLHttpAuthenticationFilter() {
        LOG.info("Creating the ODLHttpAuthenticationFilter");
    }

    protected String[] getPrincipalsAndCredentials(String scheme, String encoded) {
        String decoded = Base64.decodeToString(encoded);
        if (decoded.contains(":")) {
            return decoded.split(":");
        }
        return new String[]{encoded};
    }

    protected boolean isLoginAttempt(String authzHeader) {
        String authzScheme = this.getAuthzScheme().toLowerCase(Locale.ROOT);
        String authzHeaderLowerCase = authzHeader.toLowerCase(Locale.ROOT);
        return authzHeaderLowerCase.startsWith(authzScheme) || authzHeaderLowerCase.startsWith(BEARER_SCHEME);
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        HttpServletRequest httpRequest = WebUtils.toHttp((ServletRequest)request);
        String httpMethod = httpRequest.getMethod();
        if (OPTIONS_HEADER.equalsIgnoreCase(httpMethod)) {
            return true;
        }
        return super.isAccessAllowed((ServletRequest)httpRequest, response, mappedValue);
    }
}

