/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.oauth2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oltu.oauth2.as.issuer.OAuthIssuer;
import org.apache.oltu.oauth2.as.issuer.OAuthIssuerImpl;
import org.apache.oltu.oauth2.as.issuer.UUIDValueGenerator;
import org.apache.oltu.oauth2.as.issuer.ValueGenerator;
import org.apache.oltu.oauth2.as.response.OAuthASResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthResponse;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.message.types.TokenType;
import org.opendaylight.aaa.api.Authentication;
import org.opendaylight.aaa.api.AuthenticationException;
import org.opendaylight.aaa.api.AuthenticationService;
import org.opendaylight.aaa.api.Claim;
import org.opendaylight.aaa.api.CredentialAuth;
import org.opendaylight.aaa.api.Credentials;
import org.opendaylight.aaa.api.IdMService;
import org.opendaylight.aaa.api.PasswordCredentials;
import org.opendaylight.aaa.api.TokenStore;
import org.opendaylight.aaa.shiro.oauth2.OAuthRequest;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.AuthenticationBuilder;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.ClaimBuilder;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.PasswordCredentialBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class OAuth2TokenServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2TokenServlet.class);
    private static final long serialVersionUID = 8272453849539659999L;
    private static final String DOMAIN_SCOPE_REQUIRED = "Domain scope required";
    private static final String NOT_IMPLEMENTED = "not_implemented";
    private static final String UNAUTHORIZED = "unauthorized";
    static final String TOKEN_GRANT_ENDPOINT = "/oauth2/token";
    static final String TOKEN_REVOKE_ENDPOINT = "/oauth2/revoke";
    static final String TOKEN_VALIDATE_ENDPOINT = "/oauth2/validate";
    private final transient CredentialAuth<PasswordCredentials> credentialAuth;
    private final transient AuthenticationService authenticationService;
    private final transient TokenStore tokenStore;
    private final transient IdMService idmService;
    private transient OAuthIssuer oi;

    public OAuth2TokenServlet(CredentialAuth<PasswordCredentials> credentialAuth, AuthenticationService authenticationService, TokenStore tokenStore, IdMService idmService) {
        this.credentialAuth = credentialAuth;
        this.authenticationService = authenticationService;
        this.tokenStore = tokenStore;
        this.idmService = idmService;
    }

    public void init(ServletConfig config) throws ServletException {
        this.oi = new OAuthIssuerImpl((ValueGenerator)new UUIDValueGenerator());
    }

    public String getServletName() {
        return OAuth2TokenServlet.class.getSimpleName();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String requestURI = req.getRequestURI();
        LOG.info("Token endpoint accessed: {} {}", (Object)req.getServletPath(), (Object)requestURI);
        try {
            if (requestURI.equals(TOKEN_GRANT_ENDPOINT)) {
                this.createAccessToken(req, resp);
            } else if (requestURI.equals(TOKEN_REVOKE_ENDPOINT)) {
                this.deleteAccessToken(req, resp);
            } else if (requestURI.equals(TOKEN_VALIDATE_ENDPOINT)) {
                this.validateToken(req, resp);
            }
        }
        catch (AuthenticationException e) {
            this.error(resp, 401, e.getMessage());
        }
        catch (OAuthProblemException oe) {
            this.error(resp, oe);
        }
        catch (Exception e) {
            this.error(resp, e);
        }
    }

    private void validateToken(HttpServletRequest req, HttpServletResponse resp) throws IOException, OAuthSystemException {
        Authentication authn;
        String token = req.getReader().readLine();
        if (token != null) {
            authn = this.tokenStore.get(token.trim());
            if (authn == null) {
                throw new AuthenticationException(UNAUTHORIZED);
            }
        } else {
            throw new AuthenticationException(UNAUTHORIZED);
        }
        this.authenticationService.set(authn);
        resp.setStatus(200);
    }

    private void deleteAccessToken(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String token = req.getReader().readLine();
        if (token != null) {
            if (!this.tokenStore.delete(token.trim())) {
                throw new AuthenticationException(UNAUTHORIZED);
            }
        } else {
            throw new AuthenticationException(UNAUTHORIZED);
        }
        resp.setStatus(204);
    }

    private void createAccessToken(HttpServletRequest req, HttpServletResponse resp) throws OAuthSystemException, OAuthProblemException, IOException {
        Claim claim = null;
        String clientId = null;
        OAuthRequest oauthRequest = new OAuthRequest(req);
        if (oauthRequest.getParam("grant_type").equals(GrantType.PASSWORD.toString())) {
            String domain = (String)oauthRequest.getScopes().iterator().next();
            PasswordCredentials pc = new PasswordCredentialBuilder().setUserName(oauthRequest.getUsername()).setPassword(oauthRequest.getPassword()).setDomain(domain).build();
            if (!oauthRequest.getScopes().isEmpty()) {
                claim = this.credentialAuth.authenticate((Credentials)pc);
            }
        } else if (oauthRequest.getParam("grant_type").equals(GrantType.REFRESH_TOKEN.toString())) {
            String token = oauthRequest.getRefreshToken();
            if (!oauthRequest.getScopes().isEmpty()) {
                List roles;
                String domain = (String)oauthRequest.getScopes().iterator().next();
                Authentication auth = this.tokenStore.get(token);
                if (auth != null && domain != null && !(roles = this.idmService.listRoles(auth.userId(), domain)).isEmpty()) {
                    ClaimBuilder cb = new ClaimBuilder((Claim)auth);
                    cb.setDomain(domain);
                    for (String role : roles) {
                        cb.addRole(role);
                    }
                    claim = cb.build();
                }
            } else {
                this.error(resp, 400, DOMAIN_SCOPE_REQUIRED);
            }
        } else {
            this.error(resp, 501, NOT_IMPLEMENTED);
        }
        this.oauthAccessTokenResponse(resp, claim, clientId);
    }

    private void oauthAccessTokenResponse(HttpServletResponse resp, Claim claim, String clientId) throws OAuthSystemException, IOException {
        if (claim == null) {
            throw new AuthenticationException(UNAUTHORIZED);
        }
        String token = this.oi.accessToken();
        Authentication auth = new AuthenticationBuilder(new ClaimBuilder(claim).setClientId(clientId).build()).setExpiration(this.tokenExpiration()).build();
        this.tokenStore.put(token, auth);
        OAuthResponse response = OAuthASResponse.tokenResponse((int)201).setAccessToken(token).setTokenType(TokenType.BEARER.toString()).setExpiresIn(Long.toString(auth.expiration())).buildJSONMessage();
        this.write(resp, response);
    }

    private long tokenExpiration() {
        return this.tokenStore.tokenExpiration();
    }

    private void error(HttpServletResponse resp, int httpCode, String error) {
        try {
            OAuthResponse response = OAuthResponse.errorResponse((int)httpCode).setError(error).buildJSONMessage();
            this.write(resp, response);
        }
        catch (IOException | OAuthSystemException throwable) {
            // empty catch block
        }
    }

    private void error(HttpServletResponse resp, OAuthProblemException exception) {
        try {
            OAuthResponse response = OAuthResponse.errorResponse((int)400).error(exception).buildJSONMessage();
            this.write(resp, response);
        }
        catch (IOException | OAuthSystemException throwable) {
            // empty catch block
        }
    }

    private void error(HttpServletResponse resp, Exception exception) {
        try {
            OAuthResponse response = OAuthResponse.errorResponse((int)500).setError(exception.getClass().getName()).setErrorDescription(exception.getMessage()).buildJSONMessage();
            this.write(resp, response);
        }
        catch (IOException | OAuthSystemException throwable) {
            // empty catch block
        }
    }

    private void write(HttpServletResponse resp, OAuthResponse response) throws IOException {
        resp.setStatus(response.getResponseStatus());
        PrintWriter pw = resp.getWriter();
        pw.print(response.getBody());
        pw.flush();
        pw.close();
    }
}

