/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authz.AuthorizationFilter;
import org.opendaylight.aaa.shiro.web.env.ThreadLocals;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.HttpAuthorization;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.Policies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.permission.Permissions;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDSALDynamicAuthorizationFilter
extends AuthorizationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MDSALDynamicAuthorizationFilter.class);
    private static final DataTreeIdentifier<HttpAuthorization> AUTHZ_CONTAINER = DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)InstanceIdentifier.create(HttpAuthorization.class));
    private final ListenerRegistration<?> reg;
    private volatile ListenableFuture<Optional<HttpAuthorization>> authContainer;

    public MDSALDynamicAuthorizationFilter() {
        DataBroker dataBroker = Objects.requireNonNull(ThreadLocals.DATABROKER_TL.get());
        try (ReadTransaction tx = dataBroker.newReadOnlyTransaction();){
            this.authContainer = tx.read(AUTHZ_CONTAINER.getDatastoreType(), AUTHZ_CONTAINER.getRootIdentifier());
        }
        this.reg = dataBroker.registerDataTreeChangeListener(AUTHZ_CONTAINER, (DataTreeChangeListener)((ClusteredDataTreeChangeListener)this::onContainerChanged));
    }

    private void onContainerChanged(Collection<DataTreeModification<HttpAuthorization>> changes) {
        HttpAuthorization newVal = (HttpAuthorization)Iterables.getLast(changes).getRootNode().getDataAfter();
        LOG.debug("Updating authorization information to {}", (Object)newVal);
        this.authContainer = Futures.immediateFuture(Optional.ofNullable(newVal));
    }

    public boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        Optional authorizationOptional;
        Preconditions.checkArgument(request instanceof HttpServletRequest, "Expected HttpServletRequest, received {}", (Object)request);
        Subject subject = this.getSubject(request, response);
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String requestURI = httpServletRequest.getRequestURI();
        LOG.debug("isAccessAllowed for user={} to requestURI={}", (Object)subject, (Object)requestURI);
        try {
            authorizationOptional = (Optional)this.authContainer.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("MDSAL attempt to read Http Authz Container failed, disallowing access", e);
            return false;
        }
        if (!authorizationOptional.isPresent()) {
            LOG.debug("Authorization Container does not exist");
            return true;
        }
        HttpAuthorization httpAuthorization = (HttpAuthorization)authorizationOptional.get();
        Policies policies = httpAuthorization.getPolicies();
        List policiesList = policies.getPolicies();
        if (policiesList.isEmpty()) {
            LOG.debug("Exiting successfully early since no authorization rules exist");
            return true;
        }
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.policies.Policies policy : policiesList) {
            String resource = policy.getResource();
            boolean pathsMatch = this.pathsMatch(resource, requestURI);
            if (!pathsMatch) continue;
            LOG.debug("paths match for pattern={} and requestURI={}", (Object)resource, (Object)requestURI);
            String method = httpServletRequest.getMethod();
            LOG.trace("method={}", (Object)method);
            List permissions = policy.getPermissions();
            for (Permissions permission : permissions) {
                String role = permission.getRole();
                LOG.trace("role={}", (Object)role);
                List actions = permission.getActions();
                for (Permissions.Actions action : actions) {
                    LOG.trace("action={}", (Object)action.getName());
                    if (!action.getName().equalsIgnoreCase(method)) continue;
                    boolean hasRole = subject.hasRole(role);
                    LOG.trace("hasRole({})={}", (Object)role, (Object)hasRole);
                    if (!hasRole) continue;
                    return true;
                }
            }
            LOG.debug("couldn't authorize the user for access");
            return false;
        }
        LOG.debug("successfully authorized the user for access");
        return true;
    }

    public void destroy() {
        this.reg.close();
        super.destroy();
    }
}

