/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm.util.http.header;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.codec.Base64;

public final class HeaderUtils {
    public static final String USERNAME_DOMAIN_SEPARATOR = "@";

    private HeaderUtils() {
    }

    public static String getEncodedToken(String credentialToken) {
        return Base64.encodeToString(credentialToken.getBytes(StandardCharsets.UTF_8));
    }

    public static String getUsernamePasswordDomainString(String username, String password, String domain) {
        return username + ":" + password + ":" + domain;
    }

    public static String getTokenAuthHeader(String encodedToken) {
        return "Basic " + encodedToken;
    }

    public static Map<String, List<String>> formHeadersWithToken(String tokenAuthHeader) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        ArrayList<String> headerValue = new ArrayList<String>();
        headerValue.add(tokenAuthHeader);
        headers.put("Authorization", headerValue);
        return headers;
    }

    public static Map<String, List<String>> formHeaders(String username, String password, String domain) {
        String usernamePasswordToken = HeaderUtils.getUsernamePasswordDomainString(username, password, domain);
        String encodedToken = HeaderUtils.getEncodedToken(usernamePasswordToken);
        String tokenAuthHeader = HeaderUtils.getTokenAuthHeader(encodedToken);
        return HeaderUtils.formHeadersWithToken(tokenAuthHeader);
    }

    public static String extractUsername(String possiblyQualifiedUsername) {
        if (possiblyQualifiedUsername.contains(USERNAME_DOMAIN_SEPARATOR)) {
            String[] qualifiedUserArray = possiblyQualifiedUsername.split(USERNAME_DOMAIN_SEPARATOR);
            return qualifiedUserArray[0];
        }
        return possiblyQualifiedUsername;
    }

    public static String extractDomain(String possiblyQualifiedUsername) {
        if (possiblyQualifiedUsername.contains(USERNAME_DOMAIN_SEPARATOR)) {
            String[] qualifiedUserArray = possiblyQualifiedUsername.split(USERNAME_DOMAIN_SEPARATOR);
            return qualifiedUserArray[1];
        }
        return "sdn";
    }
}

