/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.tokenauthrealm.auth;

import java.util.Dictionary;
import org.opendaylight.aaa.api.Authentication;
import org.opendaylight.aaa.api.AuthenticationService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class AuthenticationManager
implements AuthenticationService,
ManagedService {
    private static final String AUTH_ENABLED_ERR = "Error setting authEnabled";
    protected static final String AUTH_ENABLED = "authEnabled";
    private volatile boolean authEnabled = false;
    private final ThreadLocal<Authentication> auth = new InheritableThreadLocal<Authentication>();

    public Authentication get() {
        return this.auth.get();
    }

    public void set(Authentication authentication) {
        this.auth.set(authentication);
    }

    public void clear() {
        this.auth.remove();
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        String propertyValue = (String)properties.get(AUTH_ENABLED);
        boolean isTrueString = Boolean.parseBoolean(propertyValue);
        if (!isTrueString && !"false".equalsIgnoreCase(propertyValue)) {
            throw new ConfigurationException(AUTH_ENABLED, AUTH_ENABLED_ERR);
        }
        this.authEnabled = isTrueString;
    }
}

