/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.web.env;

import javax.servlet.ServletContext;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.env.WebEnvironment;
import org.opendaylight.aaa.api.AuthenticationService;
import org.opendaylight.aaa.api.TokenStore;
import org.opendaylight.aaa.api.password.service.PasswordHashService;
import org.opendaylight.aaa.cert.api.ICertificateManager;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.TokenAuthenticators;
import org.opendaylight.aaa.shiro.web.env.AAAIniWebEnvironment;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.ShiroConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroWebEnvironmentLoaderListener
extends EnvironmentLoaderListener {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroWebEnvironmentLoaderListener.class);
    private final ShiroConfiguration shiroConfiguration;
    private final DataBroker dataBroker;
    private final ICertificateManager certificateManager;
    private final AuthenticationService authenticationService;
    private final TokenAuthenticators tokenAuthenticators;
    private final TokenStore tokenStore;
    private final PasswordHashService passwordHashService;

    public ShiroWebEnvironmentLoaderListener(ShiroConfiguration shiroConfiguration, DataBroker dataBroker, ICertificateManager certificateManager, AuthenticationService authenticationService, TokenAuthenticators tokenAuthenticators, TokenStore tokenStore, PasswordHashService passwordHashService) {
        this.shiroConfiguration = shiroConfiguration;
        this.dataBroker = dataBroker;
        this.certificateManager = certificateManager;
        this.authenticationService = authenticationService;
        this.tokenAuthenticators = tokenAuthenticators;
        this.tokenStore = tokenStore;
        this.passwordHashService = passwordHashService;
        LOG.debug("ShiroWebEnvironmentLoaderListenerImpl created");
    }

    protected WebEnvironment createEnvironment(ServletContext sc) {
        AAAIniWebEnvironment environment = new AAAIniWebEnvironment(this.shiroConfiguration, this.dataBroker, this.certificateManager, this.authenticationService, this.tokenAuthenticators, this.tokenStore, this.passwordHashService);
        environment.setServletContext(sc);
        this.customizeEnvironment((WebEnvironment)environment);
        LifecycleUtils.init((Object)((Object)environment));
        return environment;
    }
}

