/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.web.env;

import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.ws.rs.core.Application;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.filterchain.configuration.CustomFilterAdapterConfiguration;
import org.opendaylight.aaa.filterchain.filters.CustomFilterAdapter;
import org.opendaylight.aaa.shiro.idm.IdmLightApplication;
import org.opendaylight.aaa.web.FilterDetails;
import org.opendaylight.aaa.web.ServletDetails;
import org.opendaylight.aaa.web.WebContext;
import org.opendaylight.aaa.web.WebContextBuilder;
import org.opendaylight.aaa.web.WebContextRegistration;
import org.opendaylight.aaa.web.WebContextSecurer;
import org.opendaylight.aaa.web.WebServer;
import org.opendaylight.aaa.web.servlet.ServletSupport;

@Singleton
public class WebInitializer {
    private final WebContextRegistration registraton;

    @Inject
    public WebInitializer(WebServer webServer, ClaimCache claimCache, IIDMStore iidMStore, WebContextSecurer webContextSecurer, ServletSupport servletSupport, CustomFilterAdapterConfiguration customFilterAdapterConfig) throws ServletException {
        WebContextBuilder webContextBuilder = WebContext.builder().contextPath("auth").supportsSessions(true).addServlet(ServletDetails.builder().servlet((Servlet)servletSupport.createHttpServletBuilder((Application)new IdmLightApplication(iidMStore, claimCache)).build()).addUrlPattern("/*").build()).addFilter(FilterDetails.builder().filter((Filter)new CustomFilterAdapter(customFilterAdapterConfig)).addUrlPattern("/*").build());
        webContextSecurer.requireAuthentication(webContextBuilder, new String[]{"/*", "/moon/*"});
        this.registraton = webServer.registerWebContext(webContextBuilder.build());
    }

    @PreDestroy
    public void close() {
        this.registraton.close();
    }
}

