/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Variant;
import org.opendaylight.yangtools.yang.common.AbstractCanonicalValueImplementationValidator;
import org.opendaylight.yangtools.yang.common.CanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValueValidator;
import org.opendaylight.yangtools.yang.common.CanonicalValueViolation;
import org.opendaylight.yangtools.yang.common.DerivedString;

@Beta
@NonNullByDefault
@ThreadSafe
public abstract class AbstractCanonicalValueValidator<T extends DerivedString<T>, V extends T>
implements CanonicalValueValidator<T, V> {
    private static final ClassValue<Boolean> IMPLEMENTATIONS = new AbstractCanonicalValueImplementationValidator(){

        @Override
        void checkCompareTo(Class<?> type) {
        }
    };
    private final CanonicalValueSupport<T> representationSupport;
    private final Class<V> validatedClass;

    protected AbstractCanonicalValueValidator(CanonicalValueSupport<T> representationSupport, Class<V> validatedClass) {
        this.representationSupport = Objects.requireNonNull(representationSupport);
        IMPLEMENTATIONS.get(validatedClass);
        this.validatedClass = validatedClass;
    }

    @Override
    public final Class<T> getRepresentationClass() {
        return this.representationSupport.getRepresentationClass();
    }

    @Override
    public final Class<V> getValidatedRepresentationClass() {
        return this.validatedClass;
    }

    @Override
    public final Variant<T, CanonicalValueViolation> validateRepresentation(T value) {
        return this.validatedClass.isAssignableFrom(value.validator().getValidatedRepresentationClass()) ? Variant.ofFirst(this.validatedClass.cast(value)) : this.validate(value);
    }

    @Override
    public final Variant<T, CanonicalValueViolation> validateRepresentation(T value, String canonicalString) {
        return this.validatedClass.isAssignableFrom(value.validator().getValidatedRepresentationClass()) ? Variant.ofFirst(this.validatedClass.cast(value)) : this.validate(value, Objects.requireNonNull(canonicalString));
    }

    protected Variant<T, CanonicalValueViolation> validate(T value) {
        return this.validate(value, value.toCanonicalString());
    }

    protected abstract Variant<T, CanonicalValueViolation> validate(T var1, String var2);
}

