/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UQNv1;

@Beta
@NonNullByDefault
public final class UnqualifiedQName
extends AbstractQName
implements Comparable<UnqualifiedQName> {
    private static final long serialVersionUID = 1L;
    private static final Interner<UnqualifiedQName> INTERNER = Interners.newWeakInterner();

    private UnqualifiedQName(String localName) {
        super(localName);
    }

    public static UnqualifiedQName of(String localName) {
        return new UnqualifiedQName(UnqualifiedQName.checkLocalName(localName));
    }

    public static UnqualifiedQName readFrom(DataInput in) throws IOException {
        return UnqualifiedQName.of(in.readUTF());
    }

    public QName bindTo(QNameModule namespace) {
        return new QName(namespace, this.getLocalName());
    }

    @Override
    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="Interning identity check")
    public UnqualifiedQName intern() {
        String name = this.getLocalName();
        String internedName = name.intern();
        UnqualifiedQName template = internedName == name ? this : new UnqualifiedQName(internedName);
        return (UnqualifiedQName)INTERNER.intern((Object)template);
    }

    @Override
    public int compareTo(UnqualifiedQName o) {
        return this.getLocalName().compareTo(o.getLocalName());
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeUTF(this.getLocalName());
    }

    @Override
    public int hashCode() {
        return this.getLocalName().hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof UnqualifiedQName && this.getLocalName().equals(((AbstractQName)obj).getLocalName());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("localName", (Object)this.getLocalName()).toString();
    }

    @Override
    Object writeReplace() {
        return new UQNv1(this);
    }
}

