/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.simpletx;

import java.util.concurrent.ExecutionException;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.dsbenchmark.simpletx.SimpletxBaWrite;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterListKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpletxBaDelete
extends DatastoreAbstractWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SimpletxBaDelete.class);
    private final DataBroker dataBroker;

    public SimpletxBaDelete(DataBroker dataBroker, int outerListElem, int innerListElem, long writesPerTx, StartTestInput.DataStore dataStore) {
        super(StartTestInput.Operation.DELETE, outerListElem, innerListElem, writesPerTx, dataStore);
        this.dataBroker = dataBroker;
        LOG.debug("Created SimpletxBaDelete");
    }

    @Override
    public void createList() {
        LOG.debug("DatastoreDelete: creating data in the data store");
        SimpletxBaWrite dd = new SimpletxBaWrite(this.dataBroker, StartTestInput.Operation.PUT, this.outerListElem, this.innerListElem, this.outerListElem, this.dataStore);
        dd.createList();
        dd.executeList();
    }

    @Override
    public void executeList() {
        LogicalDatastoreType dsType = this.getDataStoreType();
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        long putCnt = 0L;
        for (long l = 0L; l < (long)this.outerListElem; ++l) {
            KeyedInstanceIdentifier iid = InstanceIdentifier.create(TestExec.class).child(OuterList.class, (Identifier)new OuterListKey(Integer.valueOf((int)l)));
            tx.delete(dsType, (InstanceIdentifier)iid);
            if (++putCnt != this.writesPerTx) continue;
            try {
                tx.commit().get();
                ++this.txOk;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Transaction failed: {}", (Throwable)e);
                ++this.txError;
            }
            tx = this.dataBroker.newWriteOnlyTransaction();
            putCnt = 0L;
        }
        if (putCnt != 0L) {
            try {
                tx.commit().get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Transaction failed: {}", (Throwable)e);
            }
        }
    }
}

