/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToastType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MakeToastInputBuilder
implements Builder<MakeToastInput> {
    private Long _toasterDoneness;
    private Class<? extends ToastType> _toasterToastType;
    Map<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>> augmentation = Collections.emptyMap();

    public MakeToastInputBuilder() {
    }

    public MakeToastInputBuilder(MakeToastInput base) {
        Map aug;
        this._toasterDoneness = base.getToasterDoneness();
        this._toasterToastType = base.getToasterToastType();
        if (base instanceof MakeToastInputImpl) {
            MakeToastInputImpl impl = (MakeToastInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>>(aug);
        }
    }

    public Long getToasterDoneness() {
        return this._toasterDoneness;
    }

    public Class<? extends ToastType> getToasterToastType() {
        return this._toasterToastType;
    }

    public <E$$ extends Augmentation<MakeToastInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkToasterDonenessRange(long value) {
        if (value >= 1L && value <= 10L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..10]]", (long)value);
    }

    public MakeToastInputBuilder setToasterDoneness(Long value) {
        if (value != null) {
            MakeToastInputBuilder.checkToasterDonenessRange(value);
        }
        this._toasterDoneness = value;
        return this;
    }

    public MakeToastInputBuilder setToasterToastType(Class<? extends ToastType> value) {
        this._toasterToastType = value;
        return this;
    }

    public MakeToastInputBuilder addAugmentation(Class<? extends Augmentation<MakeToastInput>> augmentationType, Augmentation<MakeToastInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MakeToastInputBuilder removeAugmentation(Class<? extends Augmentation<MakeToastInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MakeToastInput build() {
        return new MakeToastInputImpl(this);
    }

    private static final class MakeToastInputImpl
    implements MakeToastInput {
        private final Long _toasterDoneness;
        private final Class<? extends ToastType> _toasterToastType;
        private Map<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        MakeToastInputImpl(MakeToastInputBuilder base) {
            this._toasterDoneness = base.getToasterDoneness();
            this._toasterToastType = base.getToasterToastType();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<MakeToastInput> getImplementedInterface() {
            return MakeToastInput.class;
        }

        @Override
        public Long getToasterDoneness() {
            return this._toasterDoneness;
        }

        @Override
        public Class<? extends ToastType> getToasterToastType() {
            return this._toasterToastType;
        }

        public <E$$ extends Augmentation<MakeToastInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._toasterDoneness);
            result = 31 * result + Objects.hashCode(this._toasterToastType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MakeToastInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MakeToastInput other = (MakeToastInput)obj;
            if (!Objects.equals(this._toasterDoneness, other.getToasterDoneness())) {
                return false;
            }
            if (!Objects.equals(this._toasterToastType, other.getToasterToastType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MakeToastInputImpl otherImpl = (MakeToastInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"MakeToastInput");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_toasterDoneness", (Object)this._toasterDoneness);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_toasterToastType", this._toasterToastType);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

