/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterRestocked;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ToasterRestockedBuilder
implements Builder<ToasterRestocked> {
    private Long _amountOfBread;
    Map<Class<? extends Augmentation<ToasterRestocked>>, Augmentation<ToasterRestocked>> augmentation = Collections.emptyMap();

    public ToasterRestockedBuilder() {
    }

    public ToasterRestockedBuilder(ToasterRestocked base) {
        Map aug;
        this._amountOfBread = base.getAmountOfBread();
        if (base instanceof ToasterRestockedImpl) {
            ToasterRestockedImpl impl = (ToasterRestockedImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ToasterRestocked>>, Augmentation<ToasterRestocked>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ToasterRestocked>>, Augmentation<ToasterRestocked>>(aug);
        }
    }

    public Long getAmountOfBread() {
        return this._amountOfBread;
    }

    public <E$$ extends Augmentation<ToasterRestocked>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkAmountOfBreadRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public ToasterRestockedBuilder setAmountOfBread(Long value) {
        if (value != null) {
            ToasterRestockedBuilder.checkAmountOfBreadRange(value);
        }
        this._amountOfBread = value;
        return this;
    }

    public ToasterRestockedBuilder addAugmentation(Class<? extends Augmentation<ToasterRestocked>> augmentationType, Augmentation<ToasterRestocked> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ToasterRestocked>>, Augmentation<ToasterRestocked>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ToasterRestockedBuilder removeAugmentation(Class<? extends Augmentation<ToasterRestocked>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ToasterRestocked build() {
        return new ToasterRestockedImpl(this);
    }

    private static final class ToasterRestockedImpl
    implements ToasterRestocked {
        private final Long _amountOfBread;
        private Map<Class<? extends Augmentation<ToasterRestocked>>, Augmentation<ToasterRestocked>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ToasterRestockedImpl(ToasterRestockedBuilder base) {
            this._amountOfBread = base.getAmountOfBread();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<ToasterRestocked> getImplementedInterface() {
            return ToasterRestocked.class;
        }

        @Override
        public Long getAmountOfBread() {
            return this._amountOfBread;
        }

        public <E$$ extends Augmentation<ToasterRestocked>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._amountOfBread);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ToasterRestocked.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ToasterRestocked other = (ToasterRestocked)obj;
            if (!Objects.equals(this._amountOfBread, other.getAmountOfBread())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ToasterRestockedImpl otherImpl = (ToasterRestockedImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ToasterRestocked>>, Augmentation<ToasterRestocked>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ToasterRestocked");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_amountOfBread", (Object)this._amountOfBread);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

