/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.assembly;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.DeploymentEvent;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.internal.download.DownloadManager;
import org.apache.karaf.features.internal.download.Downloader;
import org.apache.karaf.features.internal.model.Config;
import org.apache.karaf.features.internal.model.ConfigFile;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.Library;
import org.apache.karaf.features.internal.service.Deployer;
import org.apache.karaf.features.internal.service.FeaturesProcessor;
import org.apache.karaf.features.internal.service.State;
import org.apache.karaf.features.internal.service.StaticInstallSupport;
import org.apache.karaf.features.internal.util.MapUtils;
import org.apache.karaf.profile.assembly.Builder;
import org.apache.karaf.profile.assembly.FakeBundleRevision;
import org.apache.karaf.util.maven.Parser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssemblyDeployCallback
extends StaticInstallSupport
implements Deployer.DeployCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(Builder.class);
    private final DownloadManager manager;
    private final Builder builder;
    private final Path homeDirectory;
    private final int defaultStartLevel;
    private final Path etcDirectory;
    private final Path systemDirectory;
    private final Deployer.DeploymentState dstate;
    private final AtomicLong nextBundleId = new AtomicLong(0L);
    private final FeaturesProcessor processor;
    private final Map<String, Bundle> bundles = new HashMap<String, Bundle>();

    public AssemblyDeployCallback(DownloadManager manager, Builder builder, BundleRevision systemBundle, Collection<Features> repositories, FeaturesProcessor processor) {
        this.manager = manager;
        this.builder = builder;
        this.homeDirectory = builder.homeDirectory;
        this.etcDirectory = this.homeDirectory.resolve("etc");
        this.systemDirectory = this.homeDirectory.resolve("system");
        this.defaultStartLevel = builder.defaultStartLevel;
        this.processor = processor;
        this.dstate = new Deployer.DeploymentState();
        this.dstate.bundles = new HashMap();
        this.dstate.bundlesPerRegion = new HashMap();
        this.dstate.filtersPerRegion = new HashMap();
        this.dstate.state = new State();
        MapUtils.addToMapSet((Map)this.dstate.bundlesPerRegion, (Object)"root", (Object)0L);
        this.dstate.bundles.put(0L, systemBundle.getBundle());
        LinkedList<org.apache.karaf.features.internal.model.Feature> features = new LinkedList<org.apache.karaf.features.internal.model.Feature>();
        for (Features repo : repositories) {
            if (repo.isBlacklisted()) continue;
            for (org.apache.karaf.features.internal.model.Feature f : repo.getFeature()) {
                if (f.isBlacklisted()) continue;
                features.add(f);
            }
        }
        this.dstate.partitionFeatures(features);
    }

    public Map<String, Integer> getStartupBundles() {
        HashMap<String, Integer> startup = new HashMap<String, Integer>();
        for (Map.Entry<String, Bundle> bundle : this.bundles.entrySet()) {
            int level = ((BundleStartLevel)bundle.getValue().adapt(BundleStartLevel.class)).getStartLevel();
            if (level <= 0) {
                level = this.defaultStartLevel;
            }
            startup.put(bundle.getKey(), level);
        }
        return startup;
    }

    public Deployer.DeploymentState getDeploymentState() {
        return this.dstate;
    }

    public void saveState(State state) {
        this.dstate.state.replace(state);
    }

    public void persistResolveRequest(Deployer.DeploymentRequest request) {
    }

    public void installConfigs(Feature feature) throws IOException {
        this.assertNotBlacklisted(feature);
        Downloader downloader = this.manager.createDownloader();
        for (Config config : ((org.apache.karaf.features.internal.model.Feature)feature).getConfig()) {
            Path configFile = this.etcDirectory.resolve(config.getName() + ".cfg");
            if (Files.exists(configFile, new LinkOption[0]) && !config.isAppend()) {
                LOGGER.info("      not changing existing config file: {}", (Object)this.homeDirectory.relativize(configFile));
                continue;
            }
            if (config.isExternal()) {
                downloader.download(config.getValue().trim(), provider -> {
                    Path input = provider.getFile().toPath();
                    byte[] data = Files.readAllBytes(input);
                    if (config.isAppend()) {
                        LOGGER.info("      appending to config file: {}", (Object)this.homeDirectory.relativize(configFile));
                        Files.write(configFile, data, StandardOpenOption.APPEND);
                    } else {
                        LOGGER.info("      adding config file: {}", (Object)this.homeDirectory.relativize(configFile));
                        Files.write(configFile, data, new OpenOption[0]);
                    }
                });
                continue;
            }
            byte[] data = config.getValue().getBytes();
            if (config.isAppend()) {
                LOGGER.info("      appending to config file: {}", (Object)this.homeDirectory.relativize(configFile));
                Files.write(configFile, data, StandardOpenOption.APPEND);
                continue;
            }
            LOGGER.info("      adding config file: {}", (Object)this.homeDirectory.relativize(configFile));
            Files.write(configFile, data, new OpenOption[0]);
        }
        for (ConfigFile configFile : ((org.apache.karaf.features.internal.model.Feature)feature).getConfigfile()) {
            String path = configFile.getFinalname();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = this.substFinalName(path);
            Path output = this.homeDirectory.resolve(path);
            String finalPath = path;
            if (!configFile.isOverride() && Files.exists(output, new LinkOption[0])) continue;
            downloader.download(configFile.getLocation(), provider -> {
                Path input = provider.getFile().toPath();
                if (configFile.isOverride()) {
                    LOGGER.info("      overwriting config file: {}", (Object)finalPath);
                } else {
                    LOGGER.info("      adding config file: {}", (Object)finalPath);
                }
                Files.copy(input, output, StandardCopyOption.REPLACE_EXISTING);
            });
        }
    }

    public void installLibraries(Feature feature) throws IOException {
        this.assertNotBlacklisted(feature);
        Downloader downloader = this.manager.createDownloader();
        ArrayList<String> libraries = new ArrayList<String>();
        for (Library library : ((org.apache.karaf.features.internal.model.Feature)feature).getLibraries()) {
            String lib = library.getLocation() + ";type:=" + library.getType() + ";export:=" + library.isExport() + ";delegate:=" + library.isDelegate();
            libraries.add(lib);
        }
        if (!libraries.isEmpty()) {
            Path configPropertiesPath = this.etcDirectory.resolve("config.properties");
            Properties configProperties = new Properties(configPropertiesPath.toFile());
            this.builder.downloadLibraries(downloader, configProperties, libraries, "   ");
        }
        try {
            downloader.await();
        }
        catch (Exception e) {
            throw new IOException("Error downloading configuration files", e);
        }
    }

    private void assertNotBlacklisted(Feature feature) {
        if (feature.isBlacklisted() && this.builder.getBlacklistPolicy() == Builder.BlacklistPolicy.Fail) {
            throw new RuntimeException("Feature " + feature.getId() + " is blacklisted");
        }
    }

    public void callListeners(DeploymentEvent deployEvent) {
    }

    public void callListeners(FeatureEvent featureEvent) {
    }

    public Bundle installBundle(String region, String uri, InputStream is) throws BundleException {
        if (this.processor.isBundleBlacklisted(uri) && this.builder.getBlacklistPolicy() == Builder.BlacklistPolicy.Fail) {
            throw new RuntimeException("Bundle " + uri + " is blacklisted");
        }
        LOGGER.info("      adding maven artifact: " + uri);
        try {
            String path;
            String regUri;
            if (uri.startsWith("mvn:")) {
                regUri = uri;
                path = Parser.pathFromMaven(uri);
            } else {
                if ((uri = uri.replaceAll("[^0-9a-zA-Z.\\-_]+", "_")).length() > 256) {
                    uri = uri.substring(0, 255);
                }
                path = "generated/" + uri;
                regUri = "file:" + path;
            }
            Path bundleSystemFile = this.systemDirectory.resolve(path);
            Files.createDirectories(bundleSystemFile.getParent(), new FileAttribute[0]);
            Files.copy(is, bundleSystemFile, StandardCopyOption.REPLACE_EXISTING);
            Hashtable<String, String> headers = new Hashtable<String, String>();
            try (JarFile jar = new JarFile(bundleSystemFile.toFile());){
                Attributes attributes = jar.getManifest().getMainAttributes();
                for (Map.Entry<Object, Object> attr : attributes.entrySet()) {
                    headers.put(attr.getKey().toString(), attr.getValue().toString());
                }
            }
            FakeBundleRevision revision = new FakeBundleRevision(headers, uri, this.nextBundleId.incrementAndGet());
            Bundle bundle = revision.getBundle();
            MapUtils.addToMapSet((Map)this.dstate.bundlesPerRegion, (Object)region, (Object)bundle.getBundleId());
            this.dstate.bundles.put(bundle.getBundleId(), bundle);
            this.bundles.put(regUri, bundle);
            return bundle;
        }
        catch (IOException e) {
            throw new BundleException("Unable to install bundle", (Throwable)e);
        }
    }

    public void setBundleStartLevel(Bundle bundle, int startLevel) {
        ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(startLevel);
    }

    public void bundleBlacklisted(BundleInfo bundleInfo) {
        LOGGER.info("      skipping blacklisted bundle: {}", (Object)bundleInfo.getLocation());
    }

    private String substFinalName(String finalname) {
        boolean startsWithVariable;
        String markerVarBeg = "${";
        String markerVarEnd = "}";
        boolean bl = startsWithVariable = finalname.startsWith("${") && finalname.contains("}");
        if (startsWithVariable) {
            String marker;
            switch (marker = finalname.substring("${".length(), finalname.indexOf("}"))) {
                case "karaf.base": {
                    return this.homeDirectory + finalname.substring(finalname.indexOf("}") + "}".length());
                }
                case "karaf.etc": {
                    return this.etcDirectory + finalname.substring(finalname.indexOf("}") + "}".length());
                }
            }
        }
        return finalname;
    }
}

