/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.command;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.ProfileService;
import org.apache.karaf.profile.impl.Utils;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(name="list", scope="profile", description="Lists all profiles")
@Service
public class ProfileList
implements Action {
    @Option(name="--hidden", description="Display hidden profiles")
    private boolean hidden;
    @Reference
    private ProfileService profileService;

    public Object execute() throws Exception {
        ArrayList<String> ids = new ArrayList<String>(this.profileService.getProfiles());
        Collections.sort(ids);
        ShellTable table = new ShellTable();
        table.column("id");
        table.column("parents");
        for (String id : ids) {
            Profile profile = this.profileService.getProfile(id);
            if (profile == null || !this.hidden && profile.isHidden()) continue;
            String parents = Utils.join(" ", profile.getParentIds());
            table.addRow().addContent(new Object[]{id, parents});
        }
        table.print(System.out);
        return null;
    }
}

