/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.network;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.NodeId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.network.Node;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.network.NodeKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.network.node.SupportingNode;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeBuilder
implements Builder<Node> {
    private NodeId _nodeId;
    private List<SupportingNode> _supportingNode;
    private NodeKey key;
    Map<Class<? extends Augmentation<Node>>, Augmentation<Node>> augmentation = Collections.emptyMap();

    public NodeBuilder() {
    }

    public NodeBuilder(Node base) {
        Map aug;
        this.key = base.key();
        this._nodeId = base.getNodeId();
        this._supportingNode = base.getSupportingNode();
        if (base instanceof NodeImpl) {
            NodeImpl impl = (NodeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>(aug);
        }
    }

    public NodeKey key() {
        return this.key;
    }

    public NodeId getNodeId() {
        return this._nodeId;
    }

    public List<SupportingNode> getSupportingNode() {
        return this._supportingNode;
    }

    public <E extends Augmentation<Node>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NodeBuilder withKey(NodeKey key) {
        this.key = key;
        return this;
    }

    public NodeBuilder setNodeId(NodeId value) {
        this._nodeId = value;
        return this;
    }

    public NodeBuilder setSupportingNode(List<SupportingNode> values) {
        this._supportingNode = values;
        return this;
    }

    public NodeBuilder addAugmentation(Class<? extends Augmentation<Node>> augmentationType, Augmentation<Node> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NodeBuilder removeAugmentation(Class<? extends Augmentation<Node>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Node build() {
        return new NodeImpl(this);
    }

    private static final class NodeImpl
    implements Node {
        private final NodeId _nodeId;
        private final List<SupportingNode> _supportingNode;
        private final NodeKey key;
        private Map<Class<? extends Augmentation<Node>>, Augmentation<Node>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NodeImpl(NodeBuilder base) {
            this.key = base.key() != null ? base.key() : new NodeKey(base.getNodeId());
            this._nodeId = this.key.getNodeId();
            this._supportingNode = base.getSupportingNode();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Node> getImplementedInterface() {
            return Node.class;
        }

        @Override
        public NodeKey key() {
            return this.key;
        }

        @Override
        public NodeId getNodeId() {
            return this._nodeId;
        }

        @Override
        public List<SupportingNode> getSupportingNode() {
            return this._supportingNode;
        }

        public <E extends Augmentation<Node>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._nodeId);
            result = 31 * result + Objects.hashCode(this._supportingNode);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Node.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Node other = (Node)obj;
            if (!Objects.equals(this._nodeId, other.getNodeId())) {
                return false;
            }
            if (!Objects.equals(this._supportingNode, other.getSupportingNode())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodeImpl otherImpl = (NodeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Node>>, Augmentation<Node>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Node");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_nodeId", (Object)this._nodeId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_supportingNode", this._supportingNode);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

