/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.network.node;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.NetworkId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.NodeId;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.network.node.SupportingNode;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network.rev180226.networks.network.node.SupportingNodeKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SupportingNodeBuilder
implements Builder<SupportingNode> {
    private NetworkId _networkRef;
    private NodeId _nodeRef;
    private SupportingNodeKey key;
    Map<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>> augmentation = Collections.emptyMap();

    public SupportingNodeBuilder() {
    }

    public SupportingNodeBuilder(SupportingNode base) {
        Map aug;
        this.key = base.key();
        this._networkRef = base.getNetworkRef();
        this._nodeRef = base.getNodeRef();
        if (base instanceof SupportingNodeImpl) {
            SupportingNodeImpl impl = (SupportingNodeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>>(aug);
        }
    }

    public SupportingNodeKey key() {
        return this.key;
    }

    public NetworkId getNetworkRef() {
        return this._networkRef;
    }

    public NodeId getNodeRef() {
        return this._nodeRef;
    }

    public <E extends Augmentation<SupportingNode>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SupportingNodeBuilder withKey(SupportingNodeKey key) {
        this.key = key;
        return this;
    }

    public SupportingNodeBuilder setNetworkRef(NetworkId value) {
        this._networkRef = value;
        return this;
    }

    public SupportingNodeBuilder setNodeRef(NodeId value) {
        this._nodeRef = value;
        return this;
    }

    public SupportingNodeBuilder addAugmentation(Class<? extends Augmentation<SupportingNode>> augmentationType, Augmentation<SupportingNode> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SupportingNodeBuilder removeAugmentation(Class<? extends Augmentation<SupportingNode>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SupportingNode build() {
        return new SupportingNodeImpl(this);
    }

    private static final class SupportingNodeImpl
    implements SupportingNode {
        private final NetworkId _networkRef;
        private final NodeId _nodeRef;
        private final SupportingNodeKey key;
        private Map<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        SupportingNodeImpl(SupportingNodeBuilder base) {
            this.key = base.key() != null ? base.key() : new SupportingNodeKey(base.getNetworkRef(), base.getNodeRef());
            this._networkRef = this.key.getNetworkRef();
            this._nodeRef = this.key.getNodeRef();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<SupportingNode> getImplementedInterface() {
            return SupportingNode.class;
        }

        @Override
        public SupportingNodeKey key() {
            return this.key;
        }

        @Override
        public NetworkId getNetworkRef() {
            return this._networkRef;
        }

        @Override
        public NodeId getNodeRef() {
            return this._nodeRef;
        }

        public <E extends Augmentation<SupportingNode>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._networkRef);
            result = 31 * result + Objects.hashCode(this._nodeRef);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SupportingNode.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SupportingNode other = (SupportingNode)obj;
            if (!Objects.equals(this._networkRef, other.getNetworkRef())) {
                return false;
            }
            if (!Objects.equals(this._nodeRef, other.getNodeRef())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SupportingNodeImpl otherImpl = (SupportingNodeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"SupportingNode");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_networkRef", (Object)this._networkRef);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_nodeRef", (Object)this._nodeRef);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

