/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.filterchain.filters;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.opendaylight.aaa.filterchain.configuration.CustomFilterAdapterConfiguration;
import org.opendaylight.aaa.filterchain.configuration.CustomFilterAdapterListener;
import org.opendaylight.aaa.filterchain.filters.AAAFilterChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFilterAdapter
implements Filter,
CustomFilterAdapterListener {
    private static final Logger LOG = LoggerFactory.getLogger(CustomFilterAdapter.class);
    private final CustomFilterAdapterConfiguration customFilterAdapterConfig;
    private FilterConfig filterConfig;
    private volatile List<Filter> injectedFilterChain = Collections.emptyList();

    public CustomFilterAdapter(CustomFilterAdapterConfiguration customFilterAdapterConfig) {
        this.customFilterAdapterConfig = customFilterAdapterConfig;
    }

    public void destroy() {
        LOG.info("Destroying CustomFilterAdapter");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        List<Filter> localFilterChain = this.injectedFilterChain;
        if (!localFilterChain.isEmpty()) {
            AAAFilterChain.createAAAFilterChain().doFilter(request, response, chain, localFilterChain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig newFilterConfig) throws ServletException {
        LOG.info("Initializing CustomFilterAdapter");
        this.filterConfig = newFilterConfig;
        this.customFilterAdapterConfig.registerCustomFilterAdapterConfigurationListener(this);
    }

    private void setInjectedFilterChain(List<Filter> filterChain) {
        this.injectedFilterChain = ImmutableList.copyOf(filterChain);
        String commaSeperatedFilterChain = this.injectedFilterChain.stream().map(i -> i.getClass().getSimpleName()).collect(Collectors.joining(","));
        LOG.info("Injecting a new filter chain with {} Filters: {}", (Object)filterChain.size(), (Object)commaSeperatedFilterChain);
    }

    @Override
    public void updateInjectedFilters(List<Filter> injectedFilters) {
        this.setInjectedFilterChain(injectedFilters);
    }

    @Override
    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }
}

