/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.imp.CommitCallback;
import com.atomikos.icatch.imp.CommitMessage;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.ForgetMessage;
import com.atomikos.icatch.imp.ForgetResult;
import com.atomikos.icatch.imp.HeurAbortedStateHandler;
import com.atomikos.icatch.imp.HeurCommittedStateHandler;
import com.atomikos.icatch.imp.HeurHazardStateHandler;
import com.atomikos.icatch.imp.HeurMixedStateHandler;
import com.atomikos.icatch.imp.Propagator;
import com.atomikos.icatch.imp.RollbackCallback;
import com.atomikos.icatch.imp.RollbackMessage;
import com.atomikos.icatch.imp.TerminatedStateHandler;
import com.atomikos.icatch.imp.TerminationResult;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;
import com.atomikos.thread.InterruptedExceptionHelper;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

abstract class CoordinatorStateHandler {
    private static final Logger LOGGER = LoggerFactory.createLogger(CoordinatorStateHandler.class);
    private transient CoordinatorImp coordinator_;
    private Set<Participant> readOnlyTable_;
    private Propagator propagator_;
    private Stack<Participant> replayStack_;
    private Boolean committed_;
    private Map<String, Integer> cascadeList_;

    protected CoordinatorStateHandler(CoordinatorImp coordinator) {
        this.coordinator_ = coordinator;
        this.replayStack_ = new Stack();
        this.readOnlyTable_ = new HashSet<Participant>();
        this.committed_ = null;
    }

    protected CoordinatorStateHandler(CoordinatorStateHandler other) {
        this.coordinator_ = other.coordinator_;
        this.propagator_ = other.propagator_;
        this.replayStack_ = other.replayStack_;
        this.readOnlyTable_ = other.readOnlyTable_;
        this.committed_ = other.committed_;
        this.cascadeList_ = other.cascadeList_;
    }

    void setCommitted() {
        this.committed_ = Boolean.TRUE;
    }

    protected CoordinatorImp getCoordinator() {
        return this.coordinator_;
    }

    protected long getRollbackTicks() {
        return 0L;
    }

    protected Stack<Participant> getReplayStack() {
        return this.replayStack_;
    }

    protected Map<String, Integer> getCascadeList() {
        return this.cascadeList_;
    }

    protected Propagator getPropagator() {
        return this.propagator_;
    }

    protected Boolean getCommitted() {
        return this.committed_;
    }

    protected boolean isCommitted() {
        if (this.committed_ == null) {
            return false;
        }
        return this.committed_;
    }

    protected void setReadOnlyTable(Set<Participant> table) {
        this.readOnlyTable_ = table;
    }

    protected void activate() {
        boolean threaded;
        boolean bl = threaded = !this.coordinator_.prefersSingleThreaded2PC();
        if (this.propagator_ == null) {
            this.propagator_ = new Propagator(threaded);
        }
    }

    protected void dispose() {
        this.propagator_ = null;
    }

    protected Boolean replayCompletion(Participant participant) throws IllegalStateException {
        if (!this.replayStack_.contains(participant)) {
            this.replayStack_.push(participant);
        }
        return this.committed_;
    }

    protected void addAllForReplay(Collection<Participant> participants) {
        for (Participant p : participants) {
            this.replayCompletion(p);
        }
    }

    protected void setCascadeList(Map<String, Integer> allParticipants) {
        this.cascadeList_ = allParticipants;
    }

    protected abstract void onTimeout();

    abstract TxState getState();

    abstract void setGlobalSiblingCount(int var1);

    protected abstract int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException;

    protected abstract void commit(boolean var1) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException;

    protected abstract void rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException;

    protected void commitFromWithinCallback(boolean heuristic, boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        CoordinatorStateHandler nextStateHandler = null;
        try {
            Vector<Participant> participants = this.coordinator_.getParticipants();
            int count = participants.size() - this.readOnlyTable_.size();
            TerminationResult commitresult = new TerminationResult(count);
            this.committed_ = Boolean.TRUE;
            try {
                this.coordinator_.setState(TxState.COMMITTING);
            }
            catch (RuntimeException error) {
                String msg = "Error in committing: " + error.getMessage() + " - recovery will clean up in the background";
                LOGGER.logWarning(msg, error);
                throw new RollbackException(msg, error);
            }
            Enumeration<Participant> enumm = participants.elements();
            while (enumm.hasMoreElements()) {
                Participant p = enumm.nextElement();
                if (this.readOnlyTable_.contains(p)) continue;
                CommitMessage cm = new CommitMessage(p, commitresult, onePhase);
                if (onePhase && this.cascadeList_ != null) {
                    Integer sibnum = this.cascadeList_.get(p);
                    if (sibnum != null) {
                        p.setGlobalSiblingCount(sibnum);
                    }
                    p.setCascadeList(this.cascadeList_);
                }
                this.propagator_.submitPropagationMessage(cm);
            }
            commitresult.waitForReplies();
            int res = commitresult.getResult();
            if (res != 0) {
                Set<Participant> hazards;
                if (res == 2) {
                    hazards = commitresult.getPossiblyIndoubts();
                    nextStateHandler = new HeurMixedStateHandler(this, hazards);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new HeurMixedException();
                }
                if (res == 6) {
                    nextStateHandler = new TerminatedStateHandler(this);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new RollbackException("Rolled back already.");
                }
                if (res == 3) {
                    nextStateHandler = new HeurAbortedStateHandler(this);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new HeurRollbackException();
                }
                if (res == 1) {
                    hazards = commitresult.getPossiblyIndoubts();
                    nextStateHandler = new HeurHazardStateHandler(this, hazards);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new HeurHazardException();
                }
            } else {
                nextStateHandler = heuristic ? new HeurCommittedStateHandler(this) : new TerminatedStateHandler(this);
                this.coordinator_.setStateHandler(nextStateHandler);
            }
        }
        catch (RuntimeException runerr) {
            throw new SysException("Error in commit: " + runerr.getMessage(), runerr);
        }
        catch (InterruptedException intr) {
            InterruptedExceptionHelper.handleInterruptedException(intr);
            throw new SysException("Error in commit" + intr.getMessage(), intr);
        }
    }

    protected void rollbackFromWithinCallback(boolean indoubt, boolean heuristic) throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        CoordinatorStateHandler nextStateHandler = null;
        try {
            this.coordinator_.setState(TxState.ABORTING);
            this.committed_ = new Boolean(false);
            Vector<Participant> participants = this.coordinator_.getParticipants();
            int count = participants.size() - this.readOnlyTable_.size();
            TerminationResult rollbackresult = new TerminationResult(count);
            Enumeration<Participant> enumm = participants.elements();
            while (enumm.hasMoreElements()) {
                Participant p = enumm.nextElement();
                if (this.readOnlyTable_.contains(p)) continue;
                RollbackMessage rm = new RollbackMessage(p, rollbackresult, indoubt);
                this.propagator_.submitPropagationMessage(rm);
            }
            rollbackresult.waitForReplies();
            int res = rollbackresult.getResult();
            if (indoubt && res != 0) {
                Set<Participant> hazards;
                if (res == 2) {
                    hazards = rollbackresult.getPossiblyIndoubts();
                    nextStateHandler = new HeurMixedStateHandler(this, hazards);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new HeurMixedException();
                }
                if (res == 4) {
                    nextStateHandler = new HeurCommittedStateHandler(this);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new HeurCommitException();
                }
                if (res == 1) {
                    hazards = rollbackresult.getPossiblyIndoubts();
                    nextStateHandler = new HeurHazardStateHandler(this, hazards);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new HeurHazardException();
                }
            } else {
                nextStateHandler = heuristic ? new HeurAbortedStateHandler(this) : new TerminatedStateHandler(this);
                this.coordinator_.setStateHandler(nextStateHandler);
            }
        }
        catch (RuntimeException runerr) {
            throw new SysException("Error in rollback: " + runerr.getMessage(), runerr);
        }
        catch (InterruptedException e) {
            InterruptedExceptionHelper.handleInterruptedException(e);
            throw new SysException("Error in rollback: " + e.getMessage(), e);
        }
    }

    protected void forget() {
        TerminatedStateHandler nextStateHandler = null;
        Vector<Participant> participants = this.coordinator_.getParticipants();
        int count = participants.size() - this.readOnlyTable_.size();
        Enumeration<Participant> enumm = participants.elements();
        ForgetResult result = new ForgetResult(count);
        while (enumm.hasMoreElements()) {
            Participant p = enumm.nextElement();
            if (this.readOnlyTable_.contains(p)) continue;
            ForgetMessage fm = new ForgetMessage(p, result);
            this.propagator_.submitPropagationMessage(fm);
        }
        try {
            result.waitForReplies();
        }
        catch (InterruptedException inter) {
            InterruptedExceptionHelper.handleInterruptedException(inter);
        }
        nextStateHandler = new TerminatedStateHandler(this);
        this.coordinator_.setStateHandler(nextStateHandler);
    }

    public void rollbackWithAfterCompletionNotification(RollbackCallback cb) throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        try {
            cb.doRollback();
            this.coordinator_.notifySynchronizationsAfterCompletion(TxState.ABORTING, TxState.TERMINATED);
        }
        catch (HeurCommitException hc) {
            this.coordinator_.notifySynchronizationsAfterCompletion(TxState.COMMITTING, TxState.TERMINATED);
            throw hc;
        }
        catch (HeurMixedException hm) {
            this.coordinator_.notifySynchronizationsAfterCompletion(TxState.ABORTING, TxState.TERMINATED);
            throw hm;
        }
        catch (HeurHazardException hh) {
            this.coordinator_.notifySynchronizationsAfterCompletion(TxState.ABORTING, TxState.TERMINATED);
            throw hh;
        }
    }

    void commitWithAfterCompletionNotification(CommitCallback cb) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        try {
            cb.doCommit();
            this.coordinator_.notifySynchronizationsAfterCompletion(TxState.COMMITTING, TxState.TERMINATED);
        }
        catch (RollbackException rb) {
            this.coordinator_.notifySynchronizationsAfterCompletion(TxState.ABORTING, TxState.TERMINATED);
            throw rb;
        }
        catch (HeurMixedException hm) {
            this.coordinator_.notifySynchronizationsAfterCompletion(TxState.COMMITTING, TxState.TERMINATED);
            throw hm;
        }
        catch (HeurHazardException hh) {
            this.coordinator_.notifySynchronizationsAfterCompletion(TxState.COMMITTING, TxState.TERMINATED);
            throw hh;
        }
        catch (HeurRollbackException hr) {
            this.coordinator_.notifySynchronizationsAfterCompletion(TxState.ABORTING, TxState.TERMINATED);
            throw hr;
        }
    }

    public void rollbackHeuristically() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        this.rollbackWithAfterCompletionNotification(new RollbackCallback(){

            @Override
            public void doRollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
                CoordinatorStateHandler.this.rollbackFromWithinCallback(true, true);
            }
        });
    }

    public void commitHeuristically() throws HeurMixedException, SysException, HeurRollbackException, HeurHazardException, IllegalStateException, RollbackException {
        this.commitWithAfterCompletionNotification(new CommitCallback(){

            @Override
            public void doCommit() throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
                CoordinatorStateHandler.this.commitFromWithinCallback(true, false);
            }
        });
    }

    protected void removePendingOltpCoordinatorFromTransactionService() {
        LOGGER.logDebug("Abandoning " + this.getCoordinator().getCoordinatorId() + " in state " + (Object)((Object)this.getState()) + " after timeout - recovery will cleanup in the background");
        this.getCoordinator().setState(TxState.ABANDONED);
    }
}

