/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.tm.impl.atomikos;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.jta.J2eeTransactionManager;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.ops4j.pax.transx.tm.ResourceFactory;
import org.ops4j.pax.transx.tm.impl.AbstractTransactionManagerWrapper;

public class TransactionManagerWrapper
extends AbstractTransactionManagerWrapper<TransactionManager> {
    Map<String, ResourceFactory> resources = new HashMap<String, ResourceFactory>();
    Map<ResourceFactory, XATransactionalResource> recoverables = new HashMap<ResourceFactory, XATransactionalResource>();

    public TransactionManagerWrapper() {
        this(TransactionManagerWrapper.initTransactionManager());
    }

    public TransactionManagerWrapper(TransactionManager tm) {
        super(tm);
    }

    private static TransactionManager initTransactionManager() {
        Configuration.init();
        return new J2eeTransactionManager();
    }

    public boolean isLastResourceCommitSupported() {
        return false;
    }

    public synchronized void registerResource(final ResourceFactory resource) {
        XATransactionalResource xatr = new XATransactionalResource(resource.getName()){

            @Override
            protected XAResource refreshXAConnection() throws ResourceException {
                return resource.create();
            }
        };
        Configuration.addResource(xatr);
        this.resources.put(resource.getName(), resource);
        this.recoverables.put(resource, xatr);
    }

    public synchronized void unregisterResource(String name) {
        ResourceFactory resource = this.resources.remove(name);
        XATransactionalResource xatr = resource != null ? this.recoverables.remove(resource) : null;
        Configuration.removeResource(name);
    }

    public synchronized ResourceFactory getResource(String name) {
        return this.resources.get(name);
    }
}

