/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.codecs;

import com.google.common.base.Preconditions;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.util.AbstractModuleStringInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class StringModuleInstanceIdentifierCodec
extends AbstractModuleStringInstanceIdentifierCodec {
    private final DataSchemaContextTree dataContextTree;
    private final SchemaContext context;
    private final String defaultPrefix;

    public StringModuleInstanceIdentifierCodec(SchemaContext context) {
        this.context = (SchemaContext)Preconditions.checkNotNull((Object)context);
        this.dataContextTree = DataSchemaContextTree.from((SchemaContext)context);
        this.defaultPrefix = "";
    }

    public StringModuleInstanceIdentifierCodec(SchemaContext context, @Nonnull String defaultPrefix) {
        this.context = (SchemaContext)Preconditions.checkNotNull((Object)context);
        this.dataContextTree = DataSchemaContextTree.from((SchemaContext)context);
        this.defaultPrefix = defaultPrefix;
    }

    protected Module moduleForPrefix(@Nonnull String prefix) {
        String moduleName = prefix.isEmpty() && !this.defaultPrefix.isEmpty() ? this.defaultPrefix : prefix;
        return this.context.findModules(moduleName).stream().findFirst().orElse(null);
    }

    @Nonnull
    public DataSchemaContextTree getDataContextTree() {
        return this.dataContextTree;
    }

    @Nullable
    protected String prefixForNamespace(@Nonnull URI namespace) {
        return this.context.findModules(namespace).stream().findFirst().map(Module::getName).orElse(null);
    }
}

