/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.handlers;

import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.nb.rfc8040.handlers.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionChainHandler
implements Handler<DOMTransactionChain>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionChainHandler.class);
    private final DOMTransactionChainListener transactionChainListener = new DOMTransactionChainListener(){

        public void onTransactionChainFailed(DOMTransactionChain chain, DOMDataTreeTransaction transaction, Throwable cause) {
            LOG.warn("TransactionChain({}) {} FAILED!", new Object[]{chain, transaction.getIdentifier(), cause});
            TransactionChainHandler.this.reset();
            throw new RestconfDocumentedException("TransactionChain(" + chain + ") not committed correctly", cause);
        }

        public void onTransactionChainSuccessful(DOMTransactionChain chain) {
            LOG.trace("TransactionChain({}) SUCCESSFUL", (Object)chain);
        }
    };
    private final DOMDataBroker dataBroker;
    private volatile DOMTransactionChain transactionChain;

    public TransactionChainHandler(DOMDataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.transactionChain = Objects.requireNonNull(dataBroker.createTransactionChain(this.transactionChainListener));
    }

    @Override
    public DOMTransactionChain get() {
        return this.transactionChain;
    }

    public synchronized void reset() {
        LOG.trace("Resetting TransactionChain({})", (Object)this.transactionChain);
        this.transactionChain.close();
        this.transactionChain = this.dataBroker.createTransactionChain(this.transactionChainListener);
    }

    @Override
    public synchronized void close() {
        this.transactionChain.close();
    }
}

