/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.jersey.providers;

import com.google.common.collect.Iterables;
import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMMountPointServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.spi.AbstractNormalizedNodeBodyReader;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.data.impl.schema.ResultAlreadySetException;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Consumes(value={"application/yang-data+json", "application/json"})
public class JsonNormalizedNodeBodyReader
extends AbstractNormalizedNodeBodyReader {
    private static final Logger LOG = LoggerFactory.getLogger(JsonNormalizedNodeBodyReader.class);

    public JsonNormalizedNodeBodyReader(SchemaContextHandler schemaContextHandler, DOMMountPointServiceHandler mountPointServiceHandler) {
        super(schemaContextHandler, mountPointServiceHandler);
    }

    @Override
    protected NormalizedNodeContext readBody(InstanceIdentifierContext<?> path, InputStream entityStream) throws WebApplicationException {
        try {
            return JsonNormalizedNodeBodyReader.readFrom(path, entityStream, this.isPost());
        }
        catch (Exception e) {
            JsonNormalizedNodeBodyReader.propagateExceptionAs(e);
            return null;
        }
    }

    public static NormalizedNodeContext readFrom(InstanceIdentifierContext<?> path, InputStream entityStream, boolean isPost) {
        NormalizedNodeResult resultHolder = new NormalizedNodeResult();
        NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
        Object parentSchema = isPost ? path.getSchemaNode() : (path.getSchemaNode() instanceof SchemaContext ? path.getSchemaContext() : (SchemaPath.ROOT.equals((Object)path.getSchemaNode().getPath().getParent()) ? path.getSchemaContext() : SchemaContextUtil.findDataSchemaNode((SchemaContext)path.getSchemaContext(), (SchemaPath)path.getSchemaNode().getPath().getParent())));
        JsonParserStream jsonParser = JsonParserStream.create((NormalizedNodeStreamWriter)writer, (JSONCodecFactory)JSONCodecFactorySupplier.RFC7951.getShared(path.getSchemaContext()), (SchemaNode)parentSchema);
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(entityStream, StandardCharsets.UTF_8));
        jsonParser.parse(reader);
        NormalizedNode result = resultHolder.getResult();
        ArrayList<Object> iiToDataList = new ArrayList<Object>();
        while (result instanceof AugmentationNode || result instanceof ChoiceNode) {
            Object childNode = ((DataContainerNode)result).getValue().iterator().next();
            if (isPost) {
                iiToDataList.add(result.getIdentifier());
            }
            result = (NormalizedNode)childNode;
        }
        if (isPost) {
            if (result instanceof MapEntryNode) {
                iiToDataList.add(new YangInstanceIdentifier.NodeIdentifier(result.getNodeType()));
                iiToDataList.add(result.getIdentifier());
            } else {
                iiToDataList.add(result.getIdentifier());
            }
        } else if (result instanceof MapNode) {
            result = (NormalizedNode)Iterables.getOnlyElement((Iterable)((MapNode)result).getValue());
        }
        YangInstanceIdentifier fullIIToData = YangInstanceIdentifier.create((Iterable)Iterables.concat((Iterable)path.getInstanceIdentifier().getPathArguments(), iiToDataList));
        InstanceIdentifierContext newIIContext = new InstanceIdentifierContext(fullIIToData, path.getSchemaNode(), path.getMountPoint(), path.getSchemaContext());
        return new NormalizedNodeContext(newIIContext, result);
    }

    private static void propagateExceptionAs(Exception exception) throws RestconfDocumentedException {
        if (exception instanceof RestconfDocumentedException) {
            throw (RestconfDocumentedException)exception;
        }
        if (exception instanceof ResultAlreadySetException) {
            LOG.debug("Error parsing json input:", (Throwable)exception);
            throw new RestconfDocumentedException("Error parsing json input: Failed to create new parse result data. Are you creating multiple resources/subresources in POST request?", (Throwable)exception);
        }
        LOG.debug("Error parsing json input", (Throwable)exception);
        throw new RestconfDocumentedException("Error parsing input: " + exception.getMessage(), RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE, (Throwable)exception);
    }
}

