/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.jersey.providers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.ParameterAwareNormalizedNodeWriter;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.api.RestconfNormalizedNodeWriter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@Provider
@Produces(value={"application/yang-data+xml", "application/xml", "text/xml"})
public class NormalizedNodeXmlBodyWriter
implements MessageBodyWriter<NormalizedNodeContext> {
    private static final XMLOutputFactory XML_FACTORY = XMLOutputFactory.newFactory();

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(NormalizedNodeContext.class);
    }

    public long getSize(NormalizedNodeContext context, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(NormalizedNodeContext context, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        XMLStreamWriter xmlWriter;
        InstanceIdentifierContext pathContext = context.getInstanceIdentifierContext();
        if (context.getData() == null) {
            return;
        }
        try {
            xmlWriter = XML_FACTORY.createXMLStreamWriter(entityStream, StandardCharsets.UTF_8.name());
            if (context.getWriterParameters().isPrettyPrint()) {
                xmlWriter = new IndentingXMLStreamWriter(xmlWriter);
            }
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        NormalizedNode data = context.getData();
        SchemaPath schemaPath = pathContext.getSchemaNode().getPath();
        NormalizedNodeXmlBodyWriter.writeNormalizedNode(xmlWriter, schemaPath, pathContext, data, context.getWriterParameters().getDepth(), context.getWriterParameters().getFields());
    }

    private static void writeNormalizedNode(XMLStreamWriter xmlWriter, SchemaPath path, InstanceIdentifierContext<?> pathContext, NormalizedNode<?, ?> data, Integer depth, List<Set<QName>> fields) throws IOException {
        RestconfNormalizedNodeWriter nnWriter;
        SchemaContext schemaCtx = pathContext.getSchemaContext();
        if (pathContext.getSchemaNode() instanceof RpcDefinition) {
            nnWriter = NormalizedNodeXmlBodyWriter.createNormalizedNodeWriter(xmlWriter, schemaCtx, ((RpcDefinition)pathContext.getSchemaNode()).getOutput().getPath(), depth, fields);
            NormalizedNodeXmlBodyWriter.writeElements(xmlWriter, nnWriter, (ContainerNode)data);
        } else {
            nnWriter = SchemaPath.ROOT.equals((Object)path) ? NormalizedNodeXmlBodyWriter.createNormalizedNodeWriter(xmlWriter, schemaCtx, path, depth, fields) : NormalizedNodeXmlBodyWriter.createNormalizedNodeWriter(xmlWriter, schemaCtx, path.getParent(), depth, fields);
            if (data instanceof MapEntryNode) {
                nnWriter.write(ImmutableNodes.mapNodeBuilder((QName)data.getNodeType()).addChild((NormalizedNode)((MapEntryNode)data)).build());
            } else {
                nnWriter.write(data);
            }
        }
        nnWriter.flush();
    }

    private static RestconfNormalizedNodeWriter createNormalizedNodeWriter(XMLStreamWriter xmlWriter, SchemaContext schemaContext, SchemaPath schemaPath, Integer depth, List<Set<QName>> fields) {
        NormalizedNodeStreamWriter xmlStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (SchemaContext)schemaContext, (SchemaPath)schemaPath);
        return ParameterAwareNormalizedNodeWriter.forStreamWriter(xmlStreamWriter, depth, fields);
    }

    private static void writeElements(XMLStreamWriter xmlWriter, RestconfNormalizedNodeWriter nnWriter, ContainerNode data) throws IOException {
        QName name = data.getNodeType();
        try {
            xmlWriter.writeStartElement("", name.getLocalName(), name.getNamespace().toString());
            xmlWriter.writeDefaultNamespace(name.getNamespace().toString());
            for (NormalizedNode child : data.getValue()) {
                nnWriter.write(child);
            }
            nnWriter.flush();
            xmlWriter.writeEndElement();
            xmlWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to write elements", e);
        }
    }

    static {
        XML_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }
}

