/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.jersey.providers;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.api.RestconfNormalizedNodeWriter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamAttributeWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ParameterAwareNormalizedNodeWriter
implements RestconfNormalizedNodeWriter {
    private static final QName ROOT_DATA_QNAME = QName.create((String)"urn:ietf:params:xml:ns:netconf:base:1.0", (String)"data");
    private final NormalizedNodeStreamWriter writer;
    private final Integer maxDepth;
    protected final List<Set<QName>> fields;
    protected int currentDepth = 0;

    private ParameterAwareNormalizedNodeWriter(NormalizedNodeStreamWriter writer, Integer maxDepth, List<Set<QName>> fields) {
        this.writer = (NormalizedNodeStreamWriter)Preconditions.checkNotNull((Object)writer);
        this.maxDepth = maxDepth;
        this.fields = fields;
    }

    protected final NormalizedNodeStreamWriter getWriter() {
        return this.writer;
    }

    public static ParameterAwareNormalizedNodeWriter forStreamWriter(NormalizedNodeStreamWriter writer, Integer maxDepth, List<Set<QName>> fields) {
        return ParameterAwareNormalizedNodeWriter.forStreamWriter(writer, true, maxDepth, fields);
    }

    public static ParameterAwareNormalizedNodeWriter forStreamWriter(NormalizedNodeStreamWriter writer, boolean orderKeyLeaves, Integer maxDepth, List<Set<QName>> fields) {
        return orderKeyLeaves ? new OrderedParameterAwareNormalizedNodeWriter(writer, maxDepth, fields) : new ParameterAwareNormalizedNodeWriter(writer, maxDepth, fields);
    }

    @Override
    public final ParameterAwareNormalizedNodeWriter write(NormalizedNode<?, ?> node) throws IOException {
        if (this.wasProcessedAsCompositeNode(node)) {
            return this;
        }
        if (this.wasProcessAsSimpleNode(node)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize node " + node);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    static final int childSizeHint(Iterable<?> children) {
        return children instanceof Collection ? ((Collection)children).size() : -1;
    }

    private boolean wasProcessAsSimpleNode(NormalizedNode<?, ?> node) throws IOException {
        if (node instanceof LeafSetEntryNode) {
            if (this.selectedByParameters(node, false)) {
                LeafSetEntryNode nodeAsLeafList = (LeafSetEntryNode)node;
                if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
                    ((NormalizedNodeStreamAttributeWriter)this.writer).leafSetEntryNode(nodeAsLeafList.getNodeType(), nodeAsLeafList.getValue(), nodeAsLeafList.getAttributes());
                } else {
                    this.writer.leafSetEntryNode(nodeAsLeafList.getNodeType(), nodeAsLeafList.getValue());
                }
            }
            return true;
        }
        if (node instanceof LeafNode) {
            LeafNode nodeAsLeaf = (LeafNode)node;
            if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
                ((NormalizedNodeStreamAttributeWriter)this.writer).leafNode((YangInstanceIdentifier.NodeIdentifier)nodeAsLeaf.getIdentifier(), nodeAsLeaf.getValue(), nodeAsLeaf.getAttributes());
            } else {
                this.writer.leafNode((YangInstanceIdentifier.NodeIdentifier)nodeAsLeaf.getIdentifier(), nodeAsLeaf.getValue());
            }
            return true;
        }
        if (node instanceof AnyXmlNode) {
            AnyXmlNode anyXmlNode = (AnyXmlNode)node;
            this.writer.anyxmlNode((YangInstanceIdentifier.NodeIdentifier)anyXmlNode.getIdentifier(), (Object)anyXmlNode.getValue());
            return true;
        }
        return false;
    }

    protected boolean selectedByParameters(NormalizedNode<?, ?> node, boolean mixinParent) {
        if (this.fields == null) {
            return this.maxDepth == null || this.currentDepth < this.maxDepth;
        }
        if (mixinParent && this.currentDepth == 0) {
            return true;
        }
        if (node instanceof AugmentationNode) {
            return true;
        }
        if (this.currentDepth > 0 && this.currentDepth <= this.fields.size()) {
            return this.fields.get(this.currentDepth - 1).contains(node.getNodeType());
        }
        return this.maxDepth == null || this.currentDepth < this.maxDepth;
    }

    protected final boolean writeChildren(Iterable<? extends NormalizedNode<?, ?>> children, boolean mixinParent) throws IOException {
        for (NormalizedNode<?, ?> child : children) {
            if (!this.selectedByParameters(child, mixinParent)) continue;
            this.write((NormalizedNode)child);
        }
        this.writer.endNode();
        return true;
    }

    protected boolean writeMapEntryChildren(MapEntryNode mapEntryNode) throws IOException {
        if (this.selectedByParameters((NormalizedNode<?, ?>)mapEntryNode, false)) {
            this.writeChildren(mapEntryNode.getValue(), false);
        } else if (this.fields == null && this.maxDepth != null && this.currentDepth == this.maxDepth) {
            this.writeOnlyKeys(mapEntryNode.getIdentifier().getKeyValues());
        }
        return true;
    }

    private void writeOnlyKeys(Map<QName, Object> keyValues) throws IllegalArgumentException, IOException {
        for (Map.Entry<QName, Object> entry : keyValues.entrySet()) {
            this.writer.leafNode(new YangInstanceIdentifier.NodeIdentifier(entry.getKey()), entry.getValue());
        }
        this.writer.endNode();
    }

    protected boolean writeMapEntryNode(MapEntryNode node) throws IOException {
        if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
            ((NormalizedNodeStreamAttributeWriter)this.writer).startMapEntryNode(node.getIdentifier(), ParameterAwareNormalizedNodeWriter.childSizeHint(node.getValue()), node.getAttributes());
        } else {
            this.writer.startMapEntryNode(node.getIdentifier(), ParameterAwareNormalizedNodeWriter.childSizeHint(node.getValue()));
        }
        ++this.currentDepth;
        this.writeMapEntryChildren(node);
        --this.currentDepth;
        return true;
    }

    private boolean wasProcessedAsCompositeNode(NormalizedNode<?, ?> node) throws IOException {
        boolean processedAsCompositeNode = false;
        if (node instanceof ContainerNode) {
            ContainerNode n = (ContainerNode)node;
            if (!n.getNodeType().withoutRevision().equals((Object)ROOT_DATA_QNAME)) {
                if (this.writer instanceof NormalizedNodeStreamAttributeWriter) {
                    ((NormalizedNodeStreamAttributeWriter)this.writer).startContainerNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), ParameterAwareNormalizedNodeWriter.childSizeHint(n.getValue()), n.getAttributes());
                } else {
                    this.writer.startContainerNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), ParameterAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
                }
                ++this.currentDepth;
                processedAsCompositeNode = this.writeChildren(n.getValue(), false);
                --this.currentDepth;
            } else {
                for (NormalizedNode child : n.getValue()) {
                    ++this.currentDepth;
                    if (this.selectedByParameters(child, false)) {
                        this.write(child);
                    }
                    --this.currentDepth;
                    processedAsCompositeNode = true;
                }
            }
        } else if (node instanceof MapEntryNode) {
            processedAsCompositeNode = this.writeMapEntryNode((MapEntryNode)node);
        } else if (node instanceof UnkeyedListEntryNode) {
            UnkeyedListEntryNode n = (UnkeyedListEntryNode)node;
            this.writer.startUnkeyedListItem((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), ParameterAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
            ++this.currentDepth;
            processedAsCompositeNode = this.writeChildren(n.getValue(), false);
            --this.currentDepth;
        } else if (node instanceof ChoiceNode) {
            ChoiceNode n = (ChoiceNode)node;
            this.writer.startChoiceNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), ParameterAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
            processedAsCompositeNode = this.writeChildren(n.getValue(), true);
        } else if (node instanceof AugmentationNode) {
            AugmentationNode n = (AugmentationNode)node;
            this.writer.startAugmentationNode(n.getIdentifier());
            processedAsCompositeNode = this.writeChildren(n.getValue(), true);
        } else if (node instanceof UnkeyedListNode) {
            UnkeyedListNode n = (UnkeyedListNode)node;
            this.writer.startUnkeyedList((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), ParameterAwareNormalizedNodeWriter.childSizeHint((Iterable)n.getValue()));
            processedAsCompositeNode = this.writeChildren((Iterable)n.getValue(), false);
        } else if (node instanceof OrderedMapNode) {
            OrderedMapNode n = (OrderedMapNode)node;
            this.writer.startOrderedMapNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), ParameterAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
            processedAsCompositeNode = this.writeChildren(n.getValue(), true);
        } else if (node instanceof MapNode) {
            MapNode n = (MapNode)node;
            this.writer.startMapNode((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), ParameterAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
            processedAsCompositeNode = this.writeChildren(n.getValue(), true);
        } else if (node instanceof LeafSetNode) {
            LeafSetNode n = (LeafSetNode)node;
            if (node instanceof OrderedLeafSetNode) {
                this.writer.startOrderedLeafSet((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), ParameterAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
            } else {
                this.writer.startLeafSet((YangInstanceIdentifier.NodeIdentifier)n.getIdentifier(), ParameterAwareNormalizedNodeWriter.childSizeHint(n.getValue()));
            }
            ++this.currentDepth;
            processedAsCompositeNode = this.writeChildren(n.getValue(), true);
            --this.currentDepth;
        }
        return processedAsCompositeNode;
    }

    private static final class OrderedParameterAwareNormalizedNodeWriter
    extends ParameterAwareNormalizedNodeWriter {
        private static final Logger LOG = LoggerFactory.getLogger(OrderedParameterAwareNormalizedNodeWriter.class);

        OrderedParameterAwareNormalizedNodeWriter(NormalizedNodeStreamWriter writer, Integer maxDepth, List<Set<QName>> fields) {
            super(writer, maxDepth, fields);
        }

        @Override
        protected boolean writeMapEntryNode(MapEntryNode node) throws IOException {
            NormalizedNodeStreamWriter writer = this.getWriter();
            if (writer instanceof NormalizedNodeStreamAttributeWriter) {
                ((NormalizedNodeStreamAttributeWriter)writer).startMapEntryNode(node.getIdentifier(), OrderedParameterAwareNormalizedNodeWriter.childSizeHint(node.getValue()), node.getAttributes());
            } else {
                writer.startMapEntryNode(node.getIdentifier(), OrderedParameterAwareNormalizedNodeWriter.childSizeHint(node.getValue()));
            }
            Set qnames = node.getIdentifier().getKeyValues().keySet();
            ++this.currentDepth;
            for (QName qname : qnames) {
                Optional child = node.getChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(qname));
                if (child.isPresent()) {
                    if (!this.selectedByParameters((NormalizedNode)child.get(), false)) continue;
                    this.write((NormalizedNode)child.get());
                    continue;
                }
                LOG.info("No child for key element {} found", (Object)qname);
            }
            --this.currentDepth;
            ++this.currentDepth;
            boolean result = this.writeChildren(Iterables.filter((Iterable)node.getValue(), input -> {
                if (input instanceof AugmentationNode) {
                    return true;
                }
                if (!qnames.contains(input.getNodeType())) {
                    return true;
                }
                LOG.debug("Skipping key child {}", input);
                return false;
            }), false);
            --this.currentDepth;
            return result;
        }
    }
}

