/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.jersey.providers;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMMountPointServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.spi.AbstractNormalizedNodeBodyReader;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.data.impl.schema.SchemaUtils;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Provider
@Consumes(value={"application/yang-data+xml", "application/xml", "text/xml"})
public class XmlNormalizedNodeBodyReader
extends AbstractNormalizedNodeBodyReader {
    private static final Logger LOG = LoggerFactory.getLogger(XmlNormalizedNodeBodyReader.class);

    public XmlNormalizedNodeBodyReader(SchemaContextHandler schemaContextHandler, DOMMountPointServiceHandler mountPointServiceHandler) {
        super(schemaContextHandler, mountPointServiceHandler);
    }

    @Override
    protected NormalizedNodeContext readBody(InstanceIdentifierContext<?> path, InputStream entityStream) throws WebApplicationException {
        try {
            Document doc = UntrustedXML.newDocumentBuilder().parse(entityStream);
            return this.parse(path, doc);
        }
        catch (RestconfDocumentedException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.debug("Error parsing xml input", (Throwable)e);
            throw new RestconfDocumentedException("Error parsing input: " + e.getMessage(), RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE, (Throwable)e);
        }
    }

    private NormalizedNodeContext parse(InstanceIdentifierContext<?> pathContext, Document doc) throws XMLStreamException, IOException, ParserConfigurationException, SAXException, URISyntaxException {
        NormalizedNode parsed;
        ContainerSchemaNode schemaNode;
        SchemaNode schemaNodeContext = pathContext.getSchemaNode();
        boolean isRpc = false;
        if (schemaNodeContext instanceof RpcDefinition) {
            schemaNode = ((RpcDefinition)schemaNodeContext).getInput();
            isRpc = true;
        } else if (schemaNodeContext instanceof DataSchemaNode) {
            schemaNode = (DataSchemaNode)schemaNodeContext;
        } else {
            throw new IllegalStateException("Unknown SchemaNode");
        }
        String docRootElm = doc.getDocumentElement().getLocalName();
        String docRootNamespace = doc.getDocumentElement().getNamespaceURI();
        ArrayList<Object> iiToDataList = new ArrayList<Object>();
        if (this.isPost() && !isRpc) {
            Deque<Object> foundSchemaNodes = XmlNormalizedNodeBodyReader.findPathToSchemaNodeByName((DataSchemaNode)schemaNode, docRootElm, docRootNamespace);
            if (foundSchemaNodes.isEmpty()) {
                throw new IllegalStateException(String.format("Child \"%s\" was not found in parent schema node \"%s\"", docRootElm, schemaNode.getQName()));
            }
            while (!foundSchemaNodes.isEmpty()) {
                Object child = foundSchemaNodes.pop();
                if (child instanceof AugmentationSchemaNode) {
                    AugmentationSchemaNode augmentSchemaNode = (AugmentationSchemaNode)child;
                    iiToDataList.add(SchemaUtils.getNodeIdentifierForAugmentation((AugmentationSchemaNode)augmentSchemaNode));
                    continue;
                }
                if (!(child instanceof DataSchemaNode)) continue;
                schemaNode = (DataSchemaNode)child;
                iiToDataList.add(new YangInstanceIdentifier.NodeIdentifier(schemaNode.getQName()));
            }
        } else if (!isRpc) {
            QName scQName = schemaNode.getQName();
            Preconditions.checkState((docRootElm.equals(scQName.getLocalName()) && docRootNamespace.equals(scQName.getNamespace().toASCIIString()) ? 1 : 0) != 0, (Object)String.format("Not correct message root element \"%s\", should be \"%s\"", docRootElm, scQName));
        }
        NormalizedNodeResult resultHolder = new NormalizedNodeResult();
        NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
        if (schemaNode instanceof ContainerSchemaNode || schemaNode instanceof ListSchemaNode || schemaNode instanceof LeafSchemaNode) {
            XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (SchemaContext)pathContext.getSchemaContext(), (SchemaNode)schemaNode);
            xmlParser.traverse(new DOMSource(doc.getDocumentElement()));
            parsed = resultHolder.getResult();
            if (parsed instanceof MapNode) {
                MapNode mapNode = (MapNode)parsed;
                parsed = (NormalizedNode)mapNode.getValue().iterator().next();
            }
            if (schemaNode instanceof ListSchemaNode && this.isPost()) {
                iiToDataList.add(parsed.getIdentifier());
            }
        } else {
            LOG.warn("Unknown schema node extension {} was not parsed", schemaNode.getClass());
            parsed = null;
        }
        YangInstanceIdentifier fullIIToData = YangInstanceIdentifier.create((Iterable)Iterables.concat((Iterable)pathContext.getInstanceIdentifier().getPathArguments(), iiToDataList));
        InstanceIdentifierContext outIIContext = new InstanceIdentifierContext(fullIIToData, pathContext.getSchemaNode(), pathContext.getMountPoint(), pathContext.getSchemaContext());
        return new NormalizedNodeContext(outIIContext, parsed);
    }

    private static Deque<Object> findPathToSchemaNodeByName(DataSchemaNode schemaNode, String elementName, String namespace) {
        ArrayDeque<Object> result = new ArrayDeque<Object>();
        ArrayList<ChoiceSchemaNode> choiceSchemaNodes = new ArrayList<ChoiceSchemaNode>();
        Collection children = ((DataNodeContainer)schemaNode).getChildNodes();
        for (DataSchemaNode child : children) {
            AugmentationSchemaNode augment;
            if (child instanceof ChoiceSchemaNode) {
                choiceSchemaNodes.add((ChoiceSchemaNode)child);
                continue;
            }
            if (!child.getQName().getLocalName().equalsIgnoreCase(elementName) || !child.getQName().getNamespace().toString().equalsIgnoreCase(namespace)) continue;
            result.push(child);
            if (child.isAugmenting() && (augment = XmlNormalizedNodeBodyReader.findCorrespondingAugment(schemaNode, child)) != null) {
                result.push(augment);
            }
            return result;
        }
        for (ChoiceSchemaNode choiceNode : choiceSchemaNodes) {
            for (CaseSchemaNode caseNode : choiceNode.getCases().values()) {
                AugmentationSchemaNode augment;
                Deque<Object> resultFromRecursion = XmlNormalizedNodeBodyReader.findPathToSchemaNodeByName((DataSchemaNode)caseNode, elementName, namespace);
                if (resultFromRecursion.isEmpty()) continue;
                resultFromRecursion.push(choiceNode);
                if (choiceNode.isAugmenting() && (augment = XmlNormalizedNodeBodyReader.findCorrespondingAugment(schemaNode, (DataSchemaNode)choiceNode)) != null) {
                    resultFromRecursion.push(augment);
                }
                return resultFromRecursion;
            }
        }
        return result;
    }

    private static AugmentationSchemaNode findCorrespondingAugment(DataSchemaNode parent, DataSchemaNode child) {
        if (parent instanceof AugmentationTarget && !(parent instanceof ChoiceSchemaNode)) {
            for (AugmentationSchemaNode augmentation : ((AugmentationTarget)parent).getAvailableAugmentations()) {
                DataSchemaNode childInAugmentation = augmentation.getDataChildByName(child.getQName());
                if (childInAugmentation == null) continue;
                return augmentation;
            }
        }
        return null;
    }
}

