/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.jersey.providers.patch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.patch.PatchContext;
import org.opendaylight.restconf.common.patch.PatchEditOperation;
import org.opendaylight.restconf.common.patch.PatchEntity;
import org.opendaylight.restconf.nb.rfc8040.codecs.StringModuleInstanceIdentifierCodec;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMMountPointServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.patch.AbstractToPatchBodyReader;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.ParserIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.data.impl.schema.ResultAlreadySetException;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Consumes(value={"application/yang.patch+json"})
public class JsonToPatchBodyReader
extends AbstractToPatchBodyReader {
    private static final Logger LOG = LoggerFactory.getLogger(JsonToPatchBodyReader.class);

    public JsonToPatchBodyReader(SchemaContextHandler schemaContextHandler, DOMMountPointServiceHandler mountPointServiceHandler) {
        super(schemaContextHandler, mountPointServiceHandler);
    }

    @Override
    protected PatchContext readBody(InstanceIdentifierContext<?> path, InputStream entityStream) throws WebApplicationException {
        try {
            return this.readFrom(path, entityStream);
        }
        catch (Exception e) {
            throw JsonToPatchBodyReader.propagateExceptionAs(e);
        }
    }

    private PatchContext readFrom(InstanceIdentifierContext<?> path, InputStream entityStream) throws IOException {
        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(entityStream, StandardCharsets.UTF_8));
        AtomicReference<String> patchId = new AtomicReference<String>();
        List<PatchEntity> resultList = this.read(jsonReader, path, patchId);
        jsonReader.close();
        return new PatchContext(path, resultList, patchId.get());
    }

    public PatchContext readFrom(String uriPath, InputStream entityStream) throws RestconfDocumentedException {
        try {
            return this.readFrom(ParserIdentifier.toInstanceIdentifier(uriPath, this.getSchemaContext(), Optional.ofNullable(this.getMountPointService())), entityStream);
        }
        catch (Exception e) {
            JsonToPatchBodyReader.propagateExceptionAs(e);
            return null;
        }
    }

    private static RuntimeException propagateExceptionAs(Exception exception) throws RestconfDocumentedException {
        if (exception instanceof RestconfDocumentedException) {
            throw (RestconfDocumentedException)((Object)exception);
        }
        if (exception instanceof ResultAlreadySetException) {
            LOG.debug("Error parsing json input:", (Throwable)exception);
            throw new RestconfDocumentedException("Error parsing json input: Failed to create new parse result data. ");
        }
        throw new RestconfDocumentedException("Error parsing json input: " + exception.getMessage(), RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE, (Throwable)exception);
    }

    private List<PatchEntity> read(JsonReader in, InstanceIdentifierContext<?> path, AtomicReference<String> patchId) throws IOException {
        ArrayList<PatchEntity> resultCollection = new ArrayList<PatchEntity>();
        StringModuleInstanceIdentifierCodec codec = new StringModuleInstanceIdentifierCodec(path.getSchemaContext());
        PatchEdit edit = new PatchEdit();
        block11: while (in.hasNext()) {
            switch (in.peek()) {
                case STRING: 
                case NUMBER: {
                    in.nextString();
                    continue block11;
                }
                case BOOLEAN: {
                    Boolean.toString(in.nextBoolean());
                    continue block11;
                }
                case NULL: {
                    in.nextNull();
                    continue block11;
                }
                case BEGIN_ARRAY: {
                    in.beginArray();
                    continue block11;
                }
                case BEGIN_OBJECT: {
                    in.beginObject();
                    continue block11;
                }
                case END_DOCUMENT: {
                    continue block11;
                }
                case NAME: {
                    this.parseByName(in.nextName(), edit, in, path, codec, resultCollection, patchId);
                    continue block11;
                }
                case END_OBJECT: {
                    in.endObject();
                    continue block11;
                }
                case END_ARRAY: {
                    in.endArray();
                    continue block11;
                }
            }
        }
        return ImmutableList.copyOf(resultCollection);
    }

    private void parseByName(@Nonnull String name, @Nonnull PatchEdit edit, @Nonnull JsonReader in, @Nonnull InstanceIdentifierContext<?> path, @Nonnull StringModuleInstanceIdentifierCodec codec, @Nonnull List<PatchEntity> resultCollection, @Nonnull AtomicReference<String> patchId) throws IOException {
        switch (name) {
            case "edit": {
                if (in.peek() == JsonToken.BEGIN_ARRAY) {
                    in.beginArray();
                    while (in.hasNext()) {
                        this.readEditDefinition(edit, in, path, codec);
                        resultCollection.add(JsonToPatchBodyReader.prepareEditOperation(edit));
                        edit.clear();
                    }
                    in.endArray();
                    break;
                }
                this.readEditDefinition(edit, in, path, codec);
                resultCollection.add(JsonToPatchBodyReader.prepareEditOperation(edit));
                edit.clear();
                break;
            }
            case "patch-id": {
                patchId.set(in.nextString());
                break;
            }
        }
    }

    private void readEditDefinition(@Nonnull PatchEdit edit, @Nonnull JsonReader in, @Nonnull InstanceIdentifierContext<?> path, @Nonnull StringModuleInstanceIdentifierCodec codec) throws IOException {
        String deferredValue = null;
        in.beginObject();
        while (in.hasNext()) {
            String editDefinition;
            switch (editDefinition = in.nextName()) {
                case "edit-id": {
                    edit.setId(in.nextString());
                    break;
                }
                case "operation": {
                    edit.setOperation(PatchEditOperation.valueOf((String)in.nextString().toUpperCase(Locale.ROOT)));
                    break;
                }
                case "target": {
                    String target = in.nextString();
                    if (target.equals("/")) {
                        edit.setTarget(path.getInstanceIdentifier());
                        edit.setTargetSchemaNode((SchemaNode)path.getSchemaContext());
                        break;
                    }
                    edit.setTarget(codec.deserialize(codec.serialize(path.getInstanceIdentifier()).concat(target)));
                    edit.setTargetSchemaNode(SchemaContextUtil.findDataSchemaNode((SchemaContext)path.getSchemaContext(), (SchemaPath)codec.getDataContextTree().getChild(edit.getTarget()).getDataSchemaNode().getPath().getParent()));
                    break;
                }
                case "value": {
                    Preconditions.checkArgument((edit.getData() == null && deferredValue == null ? 1 : 0) != 0, (Object)"Multiple value entries found");
                    if (edit.getTargetSchemaNode() == null) {
                        StringBuilder sb = new StringBuilder();
                        this.readValueNode(sb, in);
                        deferredValue = sb.toString();
                        break;
                    }
                    edit.setData(JsonToPatchBodyReader.readEditData(in, edit.getTargetSchemaNode(), path));
                    break;
                }
            }
        }
        in.endObject();
        if (deferredValue != null) {
            edit.setData(JsonToPatchBodyReader.readEditData(new JsonReader((Reader)new StringReader(deferredValue)), edit.getTargetSchemaNode(), path));
        }
    }

    private void readValueNode(@Nonnull StringBuilder sb, @Nonnull JsonReader in) throws IOException {
        in.beginObject();
        sb.append("{\"").append(in.nextName()).append("\":");
        switch (in.peek()) {
            case BEGIN_ARRAY: {
                in.beginArray();
                sb.append('[');
                while (in.hasNext()) {
                    if (in.peek() == JsonToken.STRING) {
                        sb.append('\"').append(in.nextString()).append('\"');
                    } else {
                        this.readValueObject(sb, in);
                    }
                    if (in.peek() == JsonToken.END_ARRAY) continue;
                    sb.append(',');
                }
                in.endArray();
                sb.append(']');
                break;
            }
            default: {
                this.readValueObject(sb, in);
            }
        }
        in.endObject();
        sb.append('}');
    }

    private void readValueObject(@Nonnull StringBuilder sb, @Nonnull JsonReader in) throws IOException {
        if (in.peek() == JsonToken.STRING) {
            sb.append('\"').append(in.nextString()).append('\"');
            return;
        }
        in.beginObject();
        sb.append('{');
        while (in.hasNext()) {
            sb.append('\"').append(in.nextName()).append("\":");
            switch (in.peek()) {
                case STRING: {
                    sb.append('\"').append(in.nextString()).append('\"');
                    break;
                }
                case BEGIN_ARRAY: {
                    in.beginArray();
                    sb.append('[');
                    while (in.hasNext()) {
                        if (in.peek() == JsonToken.STRING) {
                            sb.append('\"').append(in.nextString()).append('\"');
                        } else {
                            this.readValueObject(sb, in);
                        }
                        if (in.peek() == JsonToken.END_ARRAY) continue;
                        sb.append(',');
                    }
                    in.endArray();
                    sb.append(']');
                    break;
                }
                default: {
                    this.readValueObject(sb, in);
                }
            }
            if (in.peek() == JsonToken.END_OBJECT) continue;
            sb.append(',');
        }
        in.endObject();
        sb.append('}');
    }

    private static NormalizedNode<?, ?> readEditData(@Nonnull JsonReader in, @Nonnull SchemaNode targetSchemaNode, @Nonnull InstanceIdentifierContext<?> path) {
        NormalizedNodeResult resultHolder = new NormalizedNodeResult();
        NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
        JsonParserStream.create((NormalizedNodeStreamWriter)writer, (JSONCodecFactory)JSONCodecFactorySupplier.RFC7951.getShared(path.getSchemaContext()), (SchemaNode)targetSchemaNode).parse(in);
        return resultHolder.getResult();
    }

    private static PatchEntity prepareEditOperation(@Nonnull PatchEdit edit) {
        if (edit.getOperation() != null && edit.getTargetSchemaNode() != null && JsonToPatchBodyReader.checkDataPresence(edit.getOperation(), edit.getData() != null)) {
            if (!edit.getOperation().isWithValue()) {
                return new PatchEntity(edit.getId(), edit.getOperation(), edit.getTarget());
            }
            YangInstanceIdentifier targetNode = edit.getTarget().getLastPathArgument() instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates ? edit.getTarget().getParent() : edit.getTarget();
            return new PatchEntity(edit.getId(), edit.getOperation(), targetNode, edit.getData());
        }
        throw new RestconfDocumentedException("Error parsing input", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.MALFORMED_MESSAGE);
    }

    private static boolean checkDataPresence(@Nonnull PatchEditOperation operation, boolean hasData) {
        return operation.isWithValue() == hasData;
    }

    private static final class PatchEdit {
        private String id;
        private PatchEditOperation operation;
        private YangInstanceIdentifier target;
        private SchemaNode targetSchemaNode;
        private NormalizedNode<?, ?> data;

        private PatchEdit() {
        }

        String getId() {
            return this.id;
        }

        void setId(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id);
        }

        PatchEditOperation getOperation() {
            return this.operation;
        }

        void setOperation(PatchEditOperation operation) {
            this.operation = (PatchEditOperation)Preconditions.checkNotNull((Object)operation);
        }

        YangInstanceIdentifier getTarget() {
            return this.target;
        }

        void setTarget(YangInstanceIdentifier target) {
            this.target = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)target);
        }

        SchemaNode getTargetSchemaNode() {
            return this.targetSchemaNode;
        }

        void setTargetSchemaNode(SchemaNode targetSchemaNode) {
            this.targetSchemaNode = (SchemaNode)Preconditions.checkNotNull((Object)targetSchemaNode);
        }

        NormalizedNode<?, ?> getData() {
            return this.data;
        }

        void setData(NormalizedNode<?, ?> data) {
            this.data = (NormalizedNode)Preconditions.checkNotNull(data);
        }

        void clear() {
            this.id = null;
            this.operation = null;
            this.target = null;
            this.targetSchemaNode = null;
            this.data = null;
        }
    }
}

