/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.jersey.providers.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMMountPointServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.ParserIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public abstract class AbstractIdentifierAwareJaxRsProvider<T>
implements MessageBodyReader<T> {
    @Context
    private UriInfo uriInfo;
    @Context
    private Request request;
    private final SchemaContextHandler schemaContextHandler;
    private final DOMMountPointServiceHandler mountPointServiceHandler;

    protected AbstractIdentifierAwareJaxRsProvider(SchemaContextHandler schemaContextHandler, DOMMountPointServiceHandler mountPointServiceHandler) {
        this.schemaContextHandler = schemaContextHandler;
        this.mountPointServiceHandler = mountPointServiceHandler;
    }

    public final boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public final T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        InstanceIdentifierContext<?> path = this.getInstanceIdentifierContext();
        PushbackInputStream pushbackInputStream = new PushbackInputStream(entityStream);
        int firstByte = pushbackInputStream.read();
        if (firstByte == -1) {
            return this.emptyBody(path);
        }
        pushbackInputStream.unread(firstByte);
        return this.readBody(path, pushbackInputStream);
    }

    protected abstract T emptyBody(InstanceIdentifierContext<?> var1);

    protected abstract T readBody(InstanceIdentifierContext<?> var1, InputStream var2) throws WebApplicationException;

    private String getIdentifier() {
        return (String)this.uriInfo.getPathParameters(false).getFirst((Object)"identifier");
    }

    private InstanceIdentifierContext<?> getInstanceIdentifierContext() {
        return ParserIdentifier.toInstanceIdentifier(this.getIdentifier(), this.getSchemaContext(), Optional.ofNullable(this.getMountPointService()));
    }

    protected UriInfo getUriInfo() {
        return this.uriInfo;
    }

    protected SchemaContext getSchemaContext() {
        return this.schemaContextHandler.get();
    }

    protected DOMMountPointService getMountPointService() {
        return this.mountPointServiceHandler.get();
    }

    protected boolean isPost() {
        return "POST".equals(this.request.getMethod());
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public void setRequest(Request request) {
        this.request = request;
    }
}

