/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.services.api;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.patch.Patch;
import org.opendaylight.restconf.common.patch.PatchContext;
import org.opendaylight.restconf.common.patch.PatchStatusContext;
import org.opendaylight.restconf.nb.rfc8040.services.simple.api.UpdateHandlers;

public interface RestconfDataService
extends UpdateHandlers {
    @GET
    @Path(value="/data/{identifier:.+}")
    @Produces(value={"application/yang-data+json", "application/yang-data", "application/json", "application/xml", "text/xml"})
    public Response readData(@Encoded @PathParam(value="identifier") String var1, @Context UriInfo var2);

    @GET
    @Path(value="/data")
    @Produces(value={"application/yang-data+json", "application/yang-data", "application/json", "application/xml", "text/xml"})
    public Response readData(@Context UriInfo var1);

    @PUT
    @Path(value="/data/{identifier:.+}")
    @Consumes(value={"application/yang-data+json", "application/yang-data", "application/json", "application/xml", "text/xml"})
    public Response putData(@Encoded @PathParam(value="identifier") String var1, NormalizedNodeContext var2, @Context UriInfo var3);

    @POST
    @Path(value="/data/{identifier:.+}")
    @Consumes(value={"application/yang-data+json", "application/yang-data", "application/json", "application/xml", "text/xml"})
    public Response postData(@Encoded @PathParam(value="identifier") String var1, NormalizedNodeContext var2, @Context UriInfo var3);

    @POST
    @Path(value="/data")
    @Consumes(value={"application/yang-data+json", "application/yang-data", "application/json", "application/xml", "text/xml"})
    public Response postData(NormalizedNodeContext var1, @Context UriInfo var2);

    @DELETE
    @Path(value="/data/{identifier:.+}")
    public Response deleteData(@Encoded @PathParam(value="identifier") String var1);

    @Patch
    @Path(value="/data/{identifier:.+}")
    @Consumes(value={"application/yang.patch+json", "application/yang.patch+xml"})
    @Produces(value={"application/yang.patch-status+json", "application/yang.patch-status+xml"})
    public PatchStatusContext patchData(@Encoded @PathParam(value="identifier") String var1, PatchContext var2, @Context UriInfo var3);

    @Patch
    @Path(value="/data")
    @Consumes(value={"application/yang.patch+json", "application/yang.patch+xml"})
    @Produces(value={"application/yang.patch-status+json", "application/yang.patch-status+xml"})
    public PatchStatusContext patchData(PatchContext var1, @Context UriInfo var2);
}

