/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.services.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.patch.PatchContext;
import org.opendaylight.restconf.common.patch.PatchStatusContext;
import org.opendaylight.restconf.common.util.MultivaluedHashMap;
import org.opendaylight.restconf.common.util.SimpleUriInfo;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMMountPointServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.JsonNormalizedNodeBodyReader;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.NormalizedNodeJsonBodyWriter;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.patch.JsonToPatchBodyReader;
import org.opendaylight.restconf.nb.rfc8040.jersey.providers.patch.PatchJsonBodyWriter;
import org.opendaylight.restconf.nb.rfc8040.rests.services.api.JSONRestconfService;
import org.opendaylight.restconf.nb.rfc8040.rests.services.api.TransactionServicesWrapper;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.ParserIdentifier;
import org.opendaylight.yangtools.yang.common.OperationFailedException;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONRestconfServiceRfc8040Impl
implements JSONRestconfService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(JSONRestconfServiceRfc8040Impl.class);
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final TransactionServicesWrapper services;
    private final DOMMountPointServiceHandler mountPointServiceHandler;
    private final SchemaContextHandler schemaContextHandler;

    public JSONRestconfServiceRfc8040Impl(TransactionServicesWrapper services, DOMMountPointServiceHandler mountPointServiceHandler, SchemaContextHandler schemaContextHandler) {
        this.services = services;
        this.mountPointServiceHandler = mountPointServiceHandler;
        this.schemaContextHandler = schemaContextHandler;
    }

    @Override
    public void put(String uriPath, String payload) throws OperationFailedException {
        Preconditions.checkNotNull((Object)payload, (Object)"payload can't be null");
        LOG.debug("put: uriPath: {}, payload: {}", (Object)uriPath, (Object)payload);
        NormalizedNodeContext context = this.toNormalizedNodeContext(uriPath, payload, false);
        LOG.debug("Parsed YangInstanceIdentifier: {}", (Object)context.getInstanceIdentifierContext().getInstanceIdentifier());
        LOG.debug("Parsed NormalizedNode: {}", (Object)context.getData());
        try {
            this.services.putData(uriPath, context, (UriInfo)new SimpleUriInfo(uriPath));
        }
        catch (Exception e) {
            JSONRestconfServiceRfc8040Impl.propagateExceptionAs(uriPath, e, "PUT");
        }
    }

    @Override
    public void post(String uriPath, String payload) throws OperationFailedException {
        Preconditions.checkNotNull((Object)payload, (Object)"payload can't be null");
        LOG.debug("post: uriPath: {}, payload: {}", (Object)uriPath, (Object)payload);
        NormalizedNodeContext context = this.toNormalizedNodeContext(uriPath, payload, true);
        LOG.debug("Parsed YangInstanceIdentifier: {}", (Object)context.getInstanceIdentifierContext().getInstanceIdentifier());
        LOG.debug("Parsed NormalizedNode: {}", (Object)context.getData());
        try {
            this.services.postData(uriPath, context, (UriInfo)new SimpleUriInfo(uriPath));
        }
        catch (Exception e) {
            JSONRestconfServiceRfc8040Impl.propagateExceptionAs(uriPath, e, "POST");
        }
    }

    @Override
    public void delete(String uriPath) throws OperationFailedException {
        LOG.debug("delete: uriPath: {}", (Object)uriPath);
        try {
            this.services.deleteData(uriPath);
        }
        catch (Exception e) {
            JSONRestconfServiceRfc8040Impl.propagateExceptionAs(uriPath, e, "DELETE");
        }
    }

    @Override
    public Optional<String> get(String uriPath, LogicalDatastoreType datastoreType) throws OperationFailedException {
        LOG.debug("get: uriPath: {}", (Object)uriPath);
        try {
            MultivaluedHashMap queryParams = new MultivaluedHashMap();
            queryParams.putSingle((Object)"content", (Object)(datastoreType == LogicalDatastoreType.CONFIGURATION ? "config" : "nonconfig"));
            Response response = this.services.readData(uriPath, (UriInfo)new SimpleUriInfo(uriPath, (MultivaluedMap)queryParams));
            NormalizedNodeContext readData = (NormalizedNodeContext)response.getEntity();
            Optional<String> result = Optional.of(JSONRestconfServiceRfc8040Impl.toJson(readData));
            LOG.debug("get returning: {}", (Object)result.get());
            return result;
        }
        catch (Exception e) {
            if (!JSONRestconfServiceRfc8040Impl.isDataMissing(e)) {
                JSONRestconfServiceRfc8040Impl.propagateExceptionAs(uriPath, e, "GET");
            }
            LOG.debug("Data missing - returning absent");
            return Optional.empty();
        }
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"}, justification="Unrecognised NullableDecl")
    public Optional<String> invokeRpc(String uriPath, Optional<String> input) throws OperationFailedException {
        Preconditions.checkNotNull((Object)uriPath, (Object)"uriPath can't be null");
        String actualInput = input.isPresent() ? input.get() : null;
        LOG.debug("invokeRpc: uriPath: {}, input: {}", (Object)uriPath, (Object)actualInput);
        String output = null;
        try {
            NormalizedNodeContext inputContext = this.toNormalizedNodeContext(uriPath, actualInput, true);
            LOG.debug("Parsed YangInstanceIdentifier: {}", (Object)inputContext.getInstanceIdentifierContext().getInstanceIdentifier());
            LOG.debug("Parsed NormalizedNode: {}", (Object)inputContext.getData());
            NormalizedNodeContext outputContext = this.services.invokeRpc(uriPath, inputContext, (UriInfo)new SimpleUriInfo(uriPath));
            if (outputContext.getData() != null) {
                output = JSONRestconfServiceRfc8040Impl.toJson(outputContext);
            }
        }
        catch (IOException | RuntimeException e) {
            JSONRestconfServiceRfc8040Impl.propagateExceptionAs(uriPath, e, "RPC");
        }
        return Optional.ofNullable(output);
    }

    @Override
    public Optional<String> patch(String uriPath, String payload) throws OperationFailedException {
        String output = null;
        Preconditions.checkNotNull((Object)payload, (Object)"payload can't be null");
        LOG.debug("patch: uriPath: {}, payload: {}", (Object)uriPath, (Object)payload);
        ByteArrayInputStream entityStream = new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8));
        JsonToPatchBodyReader jsonToPatchBodyReader = new JsonToPatchBodyReader(this.schemaContextHandler, this.mountPointServiceHandler);
        PatchContext context = jsonToPatchBodyReader.readFrom(uriPath, (InputStream)entityStream);
        LOG.debug("Parsed YangInstanceIdentifier: {}", (Object)context.getInstanceIdentifierContext().getInstanceIdentifier());
        LOG.debug("Parsed NormalizedNode: {}", (Object)context.getData());
        try {
            PatchStatusContext patchStatusContext = this.services.patchData(context, (UriInfo)new SimpleUriInfo(uriPath));
            output = JSONRestconfServiceRfc8040Impl.toJson(patchStatusContext);
        }
        catch (Exception e) {
            JSONRestconfServiceRfc8040Impl.propagateExceptionAs(uriPath, e, "PATCH");
        }
        return Optional.ofNullable(output);
    }

    @Override
    public void close() {
    }

    private NormalizedNodeContext toNormalizedNodeContext(String uriPath, @Nullable String payload, boolean isPost) throws OperationFailedException {
        InstanceIdentifierContext<?> instanceIdentifierContext = ParserIdentifier.toInstanceIdentifier(uriPath, this.schemaContextHandler.get(), Optional.of(this.mountPointServiceHandler.get()));
        if (payload == null) {
            return new NormalizedNodeContext(instanceIdentifierContext, null);
        }
        ByteArrayInputStream entityStream = new ByteArrayInputStream(payload.getBytes(StandardCharsets.UTF_8));
        return JsonNormalizedNodeBodyReader.readFrom(instanceIdentifierContext, entityStream, isPost);
    }

    private static String toJson(PatchStatusContext patchStatusContext) throws IOException {
        PatchJsonBodyWriter writer = new PatchJsonBodyWriter();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        writer.writeTo(patchStatusContext, PatchStatusContext.class, null, EMPTY_ANNOTATIONS, MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)outputStream);
        return outputStream.toString(StandardCharsets.UTF_8.name());
    }

    private static String toJson(NormalizedNodeContext readData) throws IOException {
        NormalizedNodeJsonBodyWriter writer = new NormalizedNodeJsonBodyWriter();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        writer.writeTo(readData, NormalizedNodeContext.class, null, EMPTY_ANNOTATIONS, MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)outputStream);
        return outputStream.toString(StandardCharsets.UTF_8.name());
    }

    private static boolean isDataMissing(Exception exception) {
        if (exception instanceof RestconfDocumentedException) {
            RestconfDocumentedException rde = (RestconfDocumentedException)((Object)exception);
            return !rde.getErrors().isEmpty() && ((RestconfError)rde.getErrors().get(0)).getErrorTag() == RestconfError.ErrorTag.DATA_MISSING;
        }
        return false;
    }

    private static void propagateExceptionAs(String uriPath, Exception exception, String operation) throws OperationFailedException {
        LOG.debug("Error for uriPath: {}", (Object)uriPath, (Object)exception);
        if (exception instanceof RestconfDocumentedException) {
            throw new OperationFailedException(String.format("%s failed for URI %s", operation, uriPath), exception.getCause(), JSONRestconfServiceRfc8040Impl.toRpcErrors(((RestconfDocumentedException)((Object)exception)).getErrors()));
        }
        throw new OperationFailedException(String.format("%s failed for URI %s", operation, uriPath), (Throwable)exception, new RpcError[0]);
    }

    private static RpcError[] toRpcErrors(List<RestconfError> from) {
        RpcError[] to = new RpcError[from.size()];
        int index = 0;
        for (RestconfError e : from) {
            to[index++] = RpcResultBuilder.newError((RpcError.ErrorType)JSONRestconfServiceRfc8040Impl.toRpcErrorType(e.getErrorType()), (String)e.getErrorTag().getTagValue(), (String)e.getErrorMessage());
        }
        return to;
    }

    private static RpcError.ErrorType toRpcErrorType(RestconfError.ErrorType errorType) {
        switch (errorType) {
            case TRANSPORT: {
                return RpcError.ErrorType.TRANSPORT;
            }
            case RPC: {
                return RpcError.ErrorType.RPC;
            }
            case PROTOCOL: {
                return RpcError.ErrorType.PROTOCOL;
            }
        }
        return RpcError.ErrorType.APPLICATION;
    }
}

