/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.services.impl;

import java.net.URI;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.nb.rfc8040.handlers.RpcServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.references.SchemaContextRef;
import org.opendaylight.restconf.nb.rfc8040.rests.services.api.RestconfInvokeOperationsService;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.CreateStreamUtil;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.RestconfInvokeOperationsUtil;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.RestconfStreamsConstants;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@Path(value="/")
public class RestconfInvokeOperationsServiceImpl
implements RestconfInvokeOperationsService {
    private volatile RpcServiceHandler rpcServiceHandler;
    private volatile SchemaContextHandler schemaContextHandler;

    public RestconfInvokeOperationsServiceImpl(RpcServiceHandler rpcServiceHandler, SchemaContextHandler schemaContextHandler) {
        this.rpcServiceHandler = rpcServiceHandler;
        this.schemaContextHandler = schemaContextHandler;
    }

    @Override
    public synchronized void updateHandlers(Object ... handlers) {
        for (Object object : handlers) {
            if (object instanceof SchemaContextHandler) {
                this.schemaContextHandler = (SchemaContextHandler)object;
                continue;
            }
            if (!(object instanceof RpcServiceHandler)) continue;
            this.rpcServiceHandler = (RpcServiceHandler)object;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NormalizedNodeContext invokeRpc(String identifier, NormalizedNodeContext payload, UriInfo uriInfo) {
        SchemaContextRef schemaContextRef;
        DOMRpcResult response;
        SchemaContextRef refSchemaCtx = new SchemaContextRef(this.schemaContextHandler.get());
        SchemaPath schemaPath = payload.getInstanceIdentifierContext().getSchemaNode().getPath();
        DOMMountPoint mountPoint = payload.getInstanceIdentifierContext().getMountPoint();
        URI namespace = payload.getInstanceIdentifierContext().getSchemaNode().getQName().getNamespace();
        if (mountPoint == null) {
            if (namespace.toString().equals("urn:opendaylight:params:xml:ns:yang:controller:md:sal:remote")) {
                if (!identifier.contains(RestconfStreamsConstants.CREATE_DATA_SUBSCR)) throw new RestconfDocumentedException("Not supported operation", RestconfError.ErrorType.RPC, RestconfError.ErrorTag.OPERATION_NOT_SUPPORTED);
                response = CreateStreamUtil.createDataChangeNotifiStream(payload, refSchemaCtx);
            } else {
                response = RestconfInvokeOperationsUtil.invokeRpc(payload.getData(), schemaPath, this.rpcServiceHandler);
            }
            schemaContextRef = new SchemaContextRef(this.schemaContextHandler.get());
        } else {
            response = RestconfInvokeOperationsUtil.invokeRpcViaMountPoint(mountPoint, payload.getData(), schemaPath);
            schemaContextRef = new SchemaContextRef(mountPoint.getSchemaContext());
        }
        DOMRpcResult result = RestconfInvokeOperationsUtil.checkResponse(response);
        RpcDefinition resultNodeSchema = null;
        NormalizedNode resultData = null;
        if (result == null || result.getResult() == null) return new NormalizedNodeContext(new InstanceIdentifierContext(null, resultNodeSchema, mountPoint, schemaContextRef.get()), resultData);
        resultData = result.getResult();
        resultNodeSchema = (RpcDefinition)payload.getInstanceIdentifierContext().getSchemaNode();
        return new NormalizedNodeContext(new InstanceIdentifierContext(null, resultNodeSchema, mountPoint, schemaContextRef.get()), resultData);
    }
}

