/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.util.DataChangeScope;
import org.opendaylight.restconf.nb.rfc8040.references.SchemaContextRef;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.ResolveEnumUtil;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.RestconfStreamsConstants;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.SubscribeToStreamUtil;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.NotificationListenerAdapter;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.Notificator;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.ParserIdentifier;
import org.opendaylight.yang.gen.v1.urn.sal.restconf.event.subscription.rev140708.NotificationOutputTypeGrouping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateStreamUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CreateStreamUtil.class);
    private static final String OUTPUT_TYPE_PARAM_NAME = "notification-output-type";

    private CreateStreamUtil() {
        throw new UnsupportedOperationException("Util class");
    }

    public static DOMRpcResult createDataChangeNotifiStream(NormalizedNodeContext payload, SchemaContextRef refSchemaCtx) {
        ContainerNode data = (ContainerNode)payload.getData();
        QName qname = payload.getInstanceIdentifierContext().getSchemaNode().getQName();
        YangInstanceIdentifier path = CreateStreamUtil.preparePath(data, qname);
        String streamName = CreateStreamUtil.prepareDataChangeNotifiStreamName(path, refSchemaCtx.get(), data);
        QName outputQname = QName.create((QName)qname, (String)"output");
        QName streamNameQname = QName.create((QName)qname, (String)"stream-name");
        NotificationOutputTypeGrouping.NotificationOutputType outputType = CreateStreamUtil.prepareOutputType(data);
        if (outputType.equals((Object)NotificationOutputTypeGrouping.NotificationOutputType.JSON)) {
            streamName = streamName + "/JSON";
        }
        if (!Notificator.existListenerFor(streamName)) {
            Notificator.createListener(path, streamName, outputType);
        }
        ContainerNode output = (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(outputQname)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)streamNameQname, (Object)streamName)).build();
        return new DefaultDOMRpcResult((NormalizedNode)output);
    }

    private static NotificationOutputTypeGrouping.NotificationOutputType prepareOutputType(ContainerNode data) {
        NotificationOutputTypeGrouping.NotificationOutputType outputType = CreateStreamUtil.parseEnum(data, NotificationOutputTypeGrouping.NotificationOutputType.class, OUTPUT_TYPE_PARAM_NAME);
        return outputType == null ? NotificationOutputTypeGrouping.NotificationOutputType.XML : outputType;
    }

    private static String prepareDataChangeNotifiStreamName(YangInstanceIdentifier path, SchemaContext schemaContext, ContainerNode data) {
        LogicalDatastoreType ds = CreateStreamUtil.parseEnum(data, LogicalDatastoreType.class, "datastore");
        ds = ds == null ? RestconfStreamsConstants.DEFAULT_DS : ds;
        DataChangeScope scope = CreateStreamUtil.parseEnum(data, DataChangeScope.class, "scope");
        scope = scope == null ? RestconfStreamsConstants.DEFAULT_SCOPE : scope;
        String streamName = RestconfStreamsConstants.DATA_SUBSCR + "/" + Notificator.createStreamNameFromUri(ParserIdentifier.stringFromYangInstanceIdentifier(path, schemaContext) + "/datastore=" + ds + "/scope=" + scope);
        return streamName;
    }

    private static <T> T parseEnum(ContainerNode data, Class<T> clazz, String paramName) {
        Optional optAugNode = data.getChild((YangInstanceIdentifier.PathArgument)RestconfStreamsConstants.SAL_REMOTE_AUG_IDENTIFIER);
        if (!optAugNode.isPresent()) {
            return null;
        }
        DataContainerChild augNode = (DataContainerChild)optAugNode.get();
        if (!(augNode instanceof AugmentationNode)) {
            return null;
        }
        Optional enumNode = ((AugmentationNode)augNode).getChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(QName.create((QNameModule)RestconfStreamsConstants.SAL_REMOTE_AUGMENT, (String)paramName)));
        if (!enumNode.isPresent()) {
            return null;
        }
        Object value = ((DataContainerChild)enumNode.get()).getValue();
        if (!(value instanceof String)) {
            return null;
        }
        return ResolveEnumUtil.resolveEnum(clazz, (String)value);
    }

    private static YangInstanceIdentifier preparePath(ContainerNode data, QName qualifiedName) {
        Optional path = data.getChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)qualifiedName, (String)"path")));
        Object pathValue = null;
        if (path.isPresent()) {
            pathValue = ((DataContainerChild)path.get()).getValue();
        }
        if (!(pathValue instanceof YangInstanceIdentifier)) {
            LOG.debug("Instance identifier {} was not normalized correctly", (Object)qualifiedName);
            throw new RestconfDocumentedException("Instance identifier was not normalized correctly", RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.OPERATION_FAILED);
        }
        return (YangInstanceIdentifier)pathValue;
    }

    public static List<NotificationListenerAdapter> createYangNotifiStream(NotificationDefinition notificatinoDefinition, SchemaContextRef refSchemaCtx, String outputType) {
        ArrayList<SchemaPath> paths = new ArrayList<SchemaPath>();
        QName notificatinoDefinitionQName = notificatinoDefinition.getQName();
        Module module = refSchemaCtx.findModuleByNamespaceAndRevision(notificatinoDefinitionQName.getModule().getNamespace(), notificatinoDefinitionQName.getModule().getRevision());
        Preconditions.checkNotNull((Object)module, (Object)("Module for namespace " + notificatinoDefinitionQName.getModule().getNamespace() + " does not exist"));
        NotificationDefinition notifiDef = null;
        for (NotificationDefinition notification : module.getNotifications()) {
            if (!notification.getQName().equals((Object)notificatinoDefinitionQName)) continue;
            notifiDef = notification;
            break;
        }
        String moduleName = module.getName();
        Preconditions.checkNotNull((Object)notifiDef, (Object)("Notification " + notificatinoDefinitionQName + "doesn't exist in module " + moduleName));
        paths.add(notifiDef.getPath());
        String streamName = RestconfStreamsConstants.CREATE_NOTIFICATION_STREAM + "/";
        streamName = streamName + moduleName + ":" + notificatinoDefinitionQName.getLocalName();
        if (outputType.equals("JSON")) {
            streamName = streamName + "/JSON";
        }
        if (Notificator.existNotificationListenerFor(streamName)) {
            List<NotificationListenerAdapter> notificationListenerFor = Notificator.getNotificationListenerFor(streamName);
            return SubscribeToStreamUtil.pickSpecificListenerByOutput(notificationListenerFor, outputType);
        }
        return Notificator.createNotificationListener(paths, streamName, outputType);
    }
}

