/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.utils;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMRpcException;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.FutureDataFactory;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FutureCallbackTx {
    private static final Logger LOG = LoggerFactory.getLogger(FutureCallbackTx.class);

    private FutureCallbackTx() {
        throw new UnsupportedOperationException("Util class");
    }

    static <T> void addCallback(FluentFuture<T> listenableFuture, String txType, FutureDataFactory<? super T> dataFactory) throws RestconfDocumentedException {
        try {
            Object result = listenableFuture.get();
            dataFactory.setResult(result);
            LOG.trace("Transaction({}) SUCCESSFUL", (Object)txType);
        }
        catch (InterruptedException e) {
            dataFactory.setFailureStatus();
            LOG.warn("Transaction({}) FAILED!", (Object)txType, (Object)e);
            throw new RestconfDocumentedException("Transaction failed", (Throwable)e);
        }
        catch (ExecutionException e) {
            dataFactory.setFailureStatus();
            LOG.warn("Transaction({}) FAILED!", (Object)txType, (Object)e);
            Throwable cause = e.getCause();
            if (cause instanceof DOMRpcException) {
                dataFactory.setResult(new DefaultDOMRpcResult((Collection)ImmutableList.of((Object)RpcResultBuilder.newError((RpcError.ErrorType)RpcError.ErrorType.RPC, (String)"operation-failed", (String)cause.getMessage()))));
            }
            if (cause instanceof TransactionCommitFailedException) {
                List causalChain = Throwables.getCausalChain((Throwable)cause);
                for (Throwable error : causalChain) {
                    if (!(error instanceof NetconfDocumentedException)) continue;
                    throw new RestconfDocumentedException(error.getMessage(), RestconfError.ErrorType.valueOfCaseInsensitive((String)((NetconfDocumentedException)error).getErrorType().getTypeValue()), RestconfError.ErrorTag.valueOfCaseInsensitive((String)((NetconfDocumentedException)error).getErrorTag().getTagValue()), (Throwable)e);
                }
                throw new RestconfDocumentedException("Transaction(" + txType + ") not committed correctly", (Throwable)e);
            }
            throw new RestconfDocumentedException("Transaction failed", (Throwable)e);
        }
    }
}

