/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.utils;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;

final class ParametersUtil {
    private ParametersUtil() {
        throw new UnsupportedOperationException("Util class.");
    }

    static void checkParametersTypes(@Nonnull String operationType, @Nonnull Set<String> usedParameters, String ... allowedParameters) {
        HashSet notAllowedParameters = Sets.newHashSet(usedParameters);
        notAllowedParameters.removeAll(Sets.newHashSet((Object[])allowedParameters));
        if (!notAllowedParameters.isEmpty()) {
            throw new RestconfDocumentedException("Not allowed parameters for " + operationType + " operation: " + notAllowedParameters, RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
    }

    static void checkParameterCount(@Nonnull List<String> parameterValues, @Nonnull String parameterName) {
        if (parameterValues.size() > 1) {
            throw new RestconfDocumentedException("Parameter " + parameterName + " can appear at most once in request URI", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
    }
}

