/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.utils;

import com.google.common.util.concurrent.FluentFuture;
import java.net.URI;
import java.util.Iterator;
import java.util.Optional;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.nb.rfc8040.handlers.TransactionChainHandler;
import org.opendaylight.restconf.nb.rfc8040.references.SchemaContextRef;
import org.opendaylight.restconf.nb.rfc8040.rests.transactions.TransactionVarsWrapper;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.FutureCallbackTx;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.PutDataTransactionUtil;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.ResponseFactory;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.TransactionUtil;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.ParserIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class PostDataTransactionUtil {
    private PostDataTransactionUtil() {
        throw new UnsupportedOperationException("Util class.");
    }

    public static Response postData(UriInfo uriInfo, NormalizedNodeContext payload, TransactionVarsWrapper transactionNode, SchemaContextRef schemaContextRef, String insert, String point) {
        FluentFuture<? extends CommitInfo> future = PostDataTransactionUtil.submitData(payload.getInstanceIdentifierContext().getInstanceIdentifier(), payload.getData(), transactionNode, schemaContextRef.get(), insert, point);
        URI location = PostDataTransactionUtil.resolveLocation(uriInfo, transactionNode, schemaContextRef);
        ResponseFactory dataFactory = new ResponseFactory(Response.Status.CREATED).location(location);
        FutureCallbackTx.addCallback(future, "POST", dataFactory);
        return dataFactory.build();
    }

    private static FluentFuture<? extends CommitInfo> submitData(YangInstanceIdentifier path, NormalizedNode<?, ?> data, TransactionVarsWrapper transactionNode, SchemaContext schemaContext, String insert, String point) {
        DOMTransactionChain domTransactionChain = transactionNode.getTransactionChain();
        DOMDataTreeReadWriteTransaction newReadWriteTransaction = domTransactionChain.newReadWriteTransaction();
        if (insert == null) {
            PostDataTransactionUtil.makePost(path, data, schemaContext, transactionNode.getTransactionChainHandler(), newReadWriteTransaction);
            return newReadWriteTransaction.commit();
        }
        DataSchemaNode schemaNode = PutDataTransactionUtil.checkListAndOrderedType(schemaContext, path);
        switch (insert) {
            case "first": {
                if (schemaNode instanceof ListSchemaNode) {
                    NormalizedNode<?, ?> readData = PutDataTransactionUtil.readList(path.getParent(), schemaContext, transactionNode.getTransactionChainHandler(), schemaNode);
                    OrderedMapNode readList = (OrderedMapNode)readData;
                    if (readList == null || readList.getValue().isEmpty()) {
                        PostDataTransactionUtil.makePost(path, data, schemaContext, transactionNode.getTransactionChainHandler(), newReadWriteTransaction);
                        return newReadWriteTransaction.commit();
                    }
                    newReadWriteTransaction.delete(LogicalDatastoreType.CONFIGURATION, path.getParent().getParent());
                    PostDataTransactionUtil.simplePost(newReadWriteTransaction, LogicalDatastoreType.CONFIGURATION, path, data, schemaContext, transactionNode.getTransactionChainHandler());
                    PostDataTransactionUtil.makePost(path, readData, schemaContext, transactionNode.getTransactionChainHandler(), newReadWriteTransaction);
                    return newReadWriteTransaction.commit();
                }
                NormalizedNode<?, ?> readData = PutDataTransactionUtil.readList(path.getParent(), schemaContext, transactionNode.getTransactionChainHandler(), schemaNode);
                OrderedLeafSetNode readLeafList = (OrderedLeafSetNode)readData;
                if (readLeafList == null || readLeafList.getValue().isEmpty()) {
                    PostDataTransactionUtil.makePost(path, data, schemaContext, transactionNode.getTransactionChainHandler(), newReadWriteTransaction);
                    return newReadWriteTransaction.commit();
                }
                newReadWriteTransaction.delete(LogicalDatastoreType.CONFIGURATION, path.getParent().getParent());
                PostDataTransactionUtil.simplePost(newReadWriteTransaction, LogicalDatastoreType.CONFIGURATION, path, data, schemaContext, transactionNode.getTransactionChainHandler());
                PostDataTransactionUtil.makePost(path, readData, schemaContext, transactionNode.getTransactionChainHandler(), newReadWriteTransaction);
                return newReadWriteTransaction.commit();
            }
            case "last": {
                PostDataTransactionUtil.makePost(path, data, schemaContext, transactionNode.getTransactionChainHandler(), newReadWriteTransaction);
                return newReadWriteTransaction.commit();
            }
            case "before": {
                if (schemaNode instanceof ListSchemaNode) {
                    NormalizedNode<?, ?> readData = PutDataTransactionUtil.readList(path.getParent(), schemaContext, transactionNode.getTransactionChainHandler(), schemaNode);
                    OrderedMapNode readList = (OrderedMapNode)readData;
                    if (readList == null || readList.getValue().isEmpty()) {
                        PostDataTransactionUtil.makePost(path, data, schemaContext, transactionNode.getTransactionChainHandler(), newReadWriteTransaction);
                        return newReadWriteTransaction.commit();
                    }
                    PostDataTransactionUtil.insertWithPointListPost(newReadWriteTransaction, LogicalDatastoreType.CONFIGURATION, path, data, schemaContext, point, (MapNode)readList, true, transactionNode.getTransactionChainHandler());
                    return newReadWriteTransaction.commit();
                }
                NormalizedNode<?, ?> readData = PutDataTransactionUtil.readList(path.getParent(), schemaContext, transactionNode.getTransactionChainHandler(), schemaNode);
                OrderedLeafSetNode readLeafList = (OrderedLeafSetNode)readData;
                if (readLeafList == null || readLeafList.getValue().isEmpty()) {
                    PostDataTransactionUtil.makePost(path, data, schemaContext, transactionNode.getTransactionChainHandler(), newReadWriteTransaction);
                    return newReadWriteTransaction.commit();
                }
                PostDataTransactionUtil.insertWithPointLeafListPost(newReadWriteTransaction, LogicalDatastoreType.CONFIGURATION, path, data, schemaContext, point, readLeafList, true, transactionNode.getTransactionChainHandler());
                return newReadWriteTransaction.commit();
            }
            case "after": {
                if (schemaNode instanceof ListSchemaNode) {
                    NormalizedNode<?, ?> readData = PutDataTransactionUtil.readList(path.getParent(), schemaContext, transactionNode.getTransactionChainHandler(), schemaNode);
                    OrderedMapNode readList = (OrderedMapNode)readData;
                    if (readList == null || readList.getValue().isEmpty()) {
                        PostDataTransactionUtil.makePost(path, data, schemaContext, transactionNode.getTransactionChainHandler(), newReadWriteTransaction);
                        return newReadWriteTransaction.commit();
                    }
                    PostDataTransactionUtil.insertWithPointListPost(newReadWriteTransaction, LogicalDatastoreType.CONFIGURATION, path, data, schemaContext, point, (MapNode)readList, false, transactionNode.getTransactionChainHandler());
                    return newReadWriteTransaction.commit();
                }
                NormalizedNode<?, ?> readData = PutDataTransactionUtil.readList(path.getParent(), schemaContext, transactionNode.getTransactionChainHandler(), schemaNode);
                OrderedLeafSetNode readLeafList = (OrderedLeafSetNode)readData;
                if (readLeafList == null || readLeafList.getValue().isEmpty()) {
                    PostDataTransactionUtil.makePost(path, data, schemaContext, transactionNode.getTransactionChainHandler(), newReadWriteTransaction);
                    return newReadWriteTransaction.commit();
                }
                PostDataTransactionUtil.insertWithPointLeafListPost(newReadWriteTransaction, LogicalDatastoreType.CONFIGURATION, path, data, schemaContext, point, readLeafList, true, transactionNode.getTransactionChainHandler());
                return newReadWriteTransaction.commit();
            }
        }
        throw new RestconfDocumentedException("Used bad value of insert parameter. Possible values are first, last, before or after, but was: " + insert);
    }

    private static void insertWithPointLeafListPost(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext, String point, OrderedLeafSetNode<?> readLeafList, boolean before, TransactionChainHandler transactionChainHandler) {
        LeafSetEntryNode nodeChild;
        rwTransaction.delete(datastore, path.getParent().getParent());
        InstanceIdentifierContext<?> instanceIdentifier = ParserIdentifier.toInstanceIdentifier(point, schemaContext, Optional.empty());
        int lastItemPosition = 0;
        Iterator iterator = readLeafList.getValue().iterator();
        while (iterator.hasNext() && !(nodeChild = (LeafSetEntryNode)iterator.next()).getIdentifier().equals((Object)instanceIdentifier.getInstanceIdentifier().getLastPathArgument())) {
            ++lastItemPosition;
        }
        if (!before) {
            ++lastItemPosition;
        }
        int lastInsertedPosition = 0;
        NormalizedNode emptySubtree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path.getParent().getParent());
        rwTransaction.merge(datastore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
        for (LeafSetEntryNode nodeChild2 : readLeafList.getValue()) {
            if (lastInsertedPosition == lastItemPosition) {
                TransactionUtil.checkItemDoesNotExists(transactionChainHandler, rwTransaction, datastore, path, "POST");
                rwTransaction.put(datastore, path, payload);
            }
            YangInstanceIdentifier childPath = path.getParent().getParent().node((YangInstanceIdentifier.PathArgument)nodeChild2.getIdentifier());
            TransactionUtil.checkItemDoesNotExists(transactionChainHandler, rwTransaction, datastore, childPath, "POST");
            rwTransaction.put(datastore, childPath, (NormalizedNode)nodeChild2);
            ++lastInsertedPosition;
        }
    }

    private static void insertWithPointListPost(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext, String point, MapNode readList, boolean before, TransactionChainHandler transactionChainHandler) {
        MapEntryNode mapEntryNode;
        rwTransaction.delete(datastore, path.getParent().getParent());
        InstanceIdentifierContext<?> instanceIdentifier = ParserIdentifier.toInstanceIdentifier(point, schemaContext, Optional.empty());
        int lastItemPosition = 0;
        Iterator iterator = readList.getValue().iterator();
        while (iterator.hasNext() && !(mapEntryNode = (MapEntryNode)iterator.next()).getIdentifier().equals((Object)instanceIdentifier.getInstanceIdentifier().getLastPathArgument())) {
            ++lastItemPosition;
        }
        if (!before) {
            ++lastItemPosition;
        }
        int lastInsertedPosition = 0;
        NormalizedNode emptySubtree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path.getParent().getParent());
        rwTransaction.merge(datastore, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubtree.getIdentifier()}), emptySubtree);
        for (MapEntryNode mapEntryNode2 : readList.getValue()) {
            if (lastInsertedPosition == lastItemPosition) {
                TransactionUtil.checkItemDoesNotExists(transactionChainHandler, rwTransaction, datastore, path, "POST");
                rwTransaction.put(datastore, path, payload);
            }
            YangInstanceIdentifier childPath = path.getParent().getParent().node((YangInstanceIdentifier.PathArgument)mapEntryNode2.getIdentifier());
            TransactionUtil.checkItemDoesNotExists(transactionChainHandler, rwTransaction, datastore, childPath, "POST");
            rwTransaction.put(datastore, childPath, (NormalizedNode)mapEntryNode2);
            ++lastInsertedPosition;
        }
    }

    private static void makePost(YangInstanceIdentifier path, NormalizedNode<?, ?> data, SchemaContext schemaContext, TransactionChainHandler transactionChainHandler, DOMDataTreeReadWriteTransaction transaction) {
        if (data instanceof MapNode) {
            boolean merge = false;
            for (MapEntryNode child : ((MapNode)data).getValue()) {
                YangInstanceIdentifier childPath = path.node((YangInstanceIdentifier.PathArgument)child.getIdentifier());
                TransactionUtil.checkItemDoesNotExists(transactionChainHandler, transaction, LogicalDatastoreType.CONFIGURATION, childPath, "POST");
                if (!merge) {
                    merge = true;
                    TransactionUtil.ensureParentsByMerge(path, schemaContext, (DOMDataTreeWriteTransaction)transaction);
                    NormalizedNode emptySubTree = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)path);
                    transaction.merge(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{emptySubTree.getIdentifier()}), emptySubTree);
                }
                transaction.put(LogicalDatastoreType.CONFIGURATION, childPath, (NormalizedNode)child);
            }
        } else {
            TransactionUtil.checkItemDoesNotExists(transactionChainHandler, transaction, LogicalDatastoreType.CONFIGURATION, path, "POST");
            TransactionUtil.ensureParentsByMerge(path, schemaContext, (DOMDataTreeWriteTransaction)transaction);
            transaction.put(LogicalDatastoreType.CONFIGURATION, path, data);
        }
    }

    private static URI resolveLocation(UriInfo uriInfo, TransactionVarsWrapper transactionNode, SchemaContextRef schemaContextRef) {
        if (uriInfo == null) {
            return null;
        }
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("data");
        uriBuilder.path(ParserIdentifier.stringFromYangInstanceIdentifier(transactionNode.getInstanceIdentifier().getInstanceIdentifier(), schemaContextRef.get()));
        return uriBuilder.build(new Object[0]);
    }

    private static void simplePost(DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType datastore, YangInstanceIdentifier path, NormalizedNode<?, ?> payload, SchemaContext schemaContext, TransactionChainHandler transactionChainHandler) {
        TransactionUtil.checkItemDoesNotExists(transactionChainHandler, rwTransaction, datastore, path, "POST");
        TransactionUtil.ensureParentsByMerge(path, schemaContext, (DOMDataTreeWriteTransaction)rwTransaction);
        rwTransaction.put(datastore, path, payload);
    }
}

