/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.utils;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FluentFuture;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.WriterParameters;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.nb.rfc8040.references.SchemaContextRef;
import org.opendaylight.restconf.nb.rfc8040.rests.transactions.TransactionVarsWrapper;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.CreateStreamUtil;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.FutureCallbackTx;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.NormalizedNodeFactory;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.ParametersUtil;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.SubscribeToStreamUtil;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.NotificationListenerAdapter;
import org.opendaylight.restconf.nb.rfc8040.utils.mapping.RestconfMappingNodeUtil;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.ParserFieldsParameter;
import org.opendaylight.yang.gen.v1.urn.sal.restconf.event.subscription.rev140708.NotificationOutputTypeGrouping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class ReadDataTransactionUtil {
    private ReadDataTransactionUtil() {
        throw new UnsupportedOperationException("Util class.");
    }

    @Nonnull
    public static WriterParameters parseUriParameters(@Nonnull InstanceIdentifierContext<?> identifier, @Nullable UriInfo uriInfo, boolean tagged) {
        return ReadDataTransactionUtil.parseParams(identifier, uriInfo, tagged);
    }

    @Nonnull
    public static WriterParameters parseUriParameters(@Nonnull InstanceIdentifierContext<?> identifier, @Nullable UriInfo uriInfo) {
        return ReadDataTransactionUtil.parseParams(identifier, uriInfo, false);
    }

    private static WriterParameters parseParams(InstanceIdentifierContext<?> identifier, UriInfo uriInfo, boolean tagged) {
        WriterParameters.WriterParametersBuilder builder = new WriterParameters.WriterParametersBuilder();
        builder.setTagged(tagged);
        if (uriInfo == null) {
            return builder.build();
        }
        ParametersUtil.checkParametersTypes("READ", uriInfo.getQueryParameters().keySet(), "content", "depth", "fields", "with-defaults");
        List content = (List)uriInfo.getQueryParameters().getOrDefault((Object)"content", Collections.singletonList("all"));
        List depth = (List)uriInfo.getQueryParameters().getOrDefault((Object)"depth", Collections.singletonList("unbounded"));
        List fields = (List)uriInfo.getQueryParameters().getOrDefault((Object)"fields", Collections.emptyList());
        ParametersUtil.checkParameterCount(content, "content");
        ParametersUtil.checkParameterCount(depth, "depth");
        ParametersUtil.checkParameterCount(fields, "fields");
        String contentValue = (String)content.get(0);
        if (!(contentValue.equals("all") || contentValue.equals("config") || contentValue.equals("nonconfig"))) {
            throw new RestconfDocumentedException(new RestconfError(RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE, "Invalid content parameter: " + contentValue, null, "The content parameter value must be either config, nonconfig or all (default)"));
        }
        builder.setContent((String)content.get(0));
        if (!((String)depth.get(0)).equals("unbounded")) {
            Integer value = Ints.tryParse((String)((String)depth.get(0)));
            if (value == null || value < 1 || value > 65535) {
                throw new RestconfDocumentedException(new RestconfError(RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE, "Invalid depth parameter: " + depth, null, "The depth parameter must be an integer between 1 and 65535 or \"unbounded\""));
            }
            builder.setDepth(value.intValue());
        }
        if (!fields.isEmpty()) {
            builder.setFields(ParserFieldsParameter.parseFieldsParameter(identifier, (String)fields.get(0)));
        }
        return builder.build();
    }

    @Nullable
    public static NormalizedNode<?, ?> readData(@Nonnull String valueOfContent, @Nonnull TransactionVarsWrapper transactionNode, SchemaContext schemaContext) {
        return ReadDataTransactionUtil.readData(valueOfContent, transactionNode, null, schemaContext);
    }

    @Nullable
    public static NormalizedNode<?, ?> readData(@Nonnull String valueOfContent, @Nonnull TransactionVarsWrapper transactionNode, String withDefa, SchemaContext ctx) {
        switch (valueOfContent) {
            case "config": {
                transactionNode.setLogicalDatastoreType(LogicalDatastoreType.CONFIGURATION);
                if (withDefa == null) {
                    return ReadDataTransactionUtil.readDataViaTransaction(transactionNode);
                }
                return ReadDataTransactionUtil.prepareDataByParamWithDef(ReadDataTransactionUtil.readDataViaTransaction(transactionNode), transactionNode.getInstanceIdentifier().getInstanceIdentifier(), withDefa, ctx);
            }
            case "nonconfig": {
                transactionNode.setLogicalDatastoreType(LogicalDatastoreType.OPERATIONAL);
                return ReadDataTransactionUtil.readDataViaTransaction(transactionNode);
            }
            case "all": {
                return ReadDataTransactionUtil.readAllData(transactionNode, withDefa, ctx);
            }
        }
        throw new RestconfDocumentedException(new RestconfError(RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE, "Invalid content parameter: " + valueOfContent, null, "The content parameter value must be either config, nonconfig or all (default)"));
    }

    public static NormalizedNode<?, ?> readData(String identifier, String content, TransactionVarsWrapper transactionNode, String withDefa, SchemaContextRef schemaContextRef, UriInfo uriInfo) {
        SchemaContext schemaContext = schemaContextRef.get();
        if (identifier.contains("ietf-restconf-monitoring:restconf-state/streams") && !identifier.contains("/stream=")) {
            DOMDataTreeReadWriteTransaction wTx = transactionNode.getTransactionChain().newReadWriteTransaction();
            boolean exist = SubscribeToStreamUtil.checkExist(schemaContext, (DOMDataTreeReadTransaction)wTx);
            for (NotificationDefinition notificationDefinition : schemaContextRef.get().getNotifications()) {
                List<NotificationListenerAdapter> notifiStreamXML = CreateStreamUtil.createYangNotifiStream(notificationDefinition, schemaContextRef, NotificationOutputTypeGrouping.NotificationOutputType.XML.getName());
                List<NotificationListenerAdapter> notifiStreamJSON = CreateStreamUtil.createYangNotifiStream(notificationDefinition, schemaContextRef, NotificationOutputTypeGrouping.NotificationOutputType.JSON.getName());
                for (NotificationListenerAdapter listener : Iterables.concat(notifiStreamXML, notifiStreamJSON)) {
                    URI uri = SubscribeToStreamUtil.prepareUriByStreamName(uriInfo, listener.getStreamName());
                    NormalizedNode mapToStreams = RestconfMappingNodeUtil.mapYangNotificationStreamByIetfRestconfMonitoring(listener.getSchemaPath().getLastComponent(), schemaContext.getNotifications(), null, listener.getOutputType(), uri, SubscribeToStreamUtil.getMonitoringModule(schemaContext), exist);
                    SubscribeToStreamUtil.writeDataToDS(schemaContext, listener.getSchemaPath().getLastComponent().getLocalName(), wTx, exist, mapToStreams);
                }
            }
            SubscribeToStreamUtil.submitData(wTx);
        }
        return ReadDataTransactionUtil.readData(content, transactionNode, withDefa, schemaContext);
    }

    private static NormalizedNode<?, ?> prepareDataByParamWithDef(NormalizedNode<?, ?> result, YangInstanceIdentifier path, String withDefa, SchemaContext ctx) {
        boolean trim;
        switch (withDefa) {
            case "trim": {
                trim = true;
                break;
            }
            case "explicit": {
                trim = false;
                break;
            }
            default: {
                throw new RestconfDocumentedException("");
            }
        }
        DataSchemaContextTree baseSchemaCtxTree = DataSchemaContextTree.from((SchemaContext)ctx);
        DataSchemaNode baseSchemaNode = baseSchemaCtxTree.getChild(path).getDataSchemaNode();
        if (result instanceof ContainerNode) {
            DataContainerNodeAttrBuilder builder = Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)baseSchemaNode));
            ReadDataTransactionUtil.buildCont((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode>)builder, (ContainerNode)result, baseSchemaCtxTree, path, trim);
            return builder.build();
        }
        DataContainerNodeAttrBuilder builder = Builders.mapEntryBuilder((ListSchemaNode)((ListSchemaNode)baseSchemaNode));
        ReadDataTransactionUtil.buildMapEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)builder, (MapEntryNode)result, baseSchemaCtxTree, path, trim, ((ListSchemaNode)baseSchemaNode).getKeyDefinition());
        return builder.build();
    }

    private static void buildMapEntryBuilder(DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> builder, MapEntryNode result, DataSchemaContextTree baseSchemaCtxTree, YangInstanceIdentifier actualPath, boolean trim, List<QName> keys) {
        for (DataContainerChild child : result.getValue()) {
            DataContainerNodeAttrBuilder childBuilder;
            YangInstanceIdentifier path = actualPath.node(child.getIdentifier());
            DataSchemaNode childSchema = baseSchemaCtxTree.getChild(path).getDataSchemaNode();
            if (child instanceof ContainerNode) {
                childBuilder = Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)childSchema));
                ReadDataTransactionUtil.buildCont((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode>)childBuilder, (ContainerNode)child, baseSchemaCtxTree, path, trim);
                builder.withChild((DataContainerChild)childBuilder.build());
                continue;
            }
            if (child instanceof MapNode) {
                childBuilder = Builders.mapBuilder((ListSchemaNode)((ListSchemaNode)childSchema));
                ReadDataTransactionUtil.buildList((CollectionNodeBuilder<MapEntryNode, MapNode>)childBuilder, (MapNode)child, baseSchemaCtxTree, path, trim, ((ListSchemaNode)childSchema).getKeyDefinition());
                builder.withChild((DataContainerChild)childBuilder.build());
                continue;
            }
            if (!(child instanceof LeafNode)) continue;
            Object defaultVal = ((LeafSchemaNode)childSchema).getType().getDefaultValue().orElse(null);
            Object nodeVal = child.getValue();
            NormalizedNodeAttrBuilder leafBuilder = Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)childSchema));
            if (keys.contains(child.getNodeType())) {
                leafBuilder.withValue(((LeafNode)child).getValue());
                builder.withChild((DataContainerChild)leafBuilder.build());
                continue;
            }
            if (trim) {
                if (defaultVal != null && defaultVal.equals(nodeVal)) continue;
                leafBuilder.withValue(((LeafNode)child).getValue());
                builder.withChild((DataContainerChild)leafBuilder.build());
                continue;
            }
            if (defaultVal == null || !defaultVal.equals(nodeVal)) continue;
            leafBuilder.withValue(((LeafNode)child).getValue());
            builder.withChild((DataContainerChild)leafBuilder.build());
        }
    }

    private static void buildList(CollectionNodeBuilder<MapEntryNode, MapNode> builder, MapNode result, DataSchemaContextTree baseSchemaCtxTree, YangInstanceIdentifier path, boolean trim, List<QName> keys) {
        for (MapEntryNode mapEntryNode : result.getValue()) {
            YangInstanceIdentifier actualNode = path.node((YangInstanceIdentifier.PathArgument)mapEntryNode.getIdentifier());
            DataSchemaNode childSchema = baseSchemaCtxTree.getChild(actualNode).getDataSchemaNode();
            DataContainerNodeAttrBuilder mapEntryBuilder = Builders.mapEntryBuilder((ListSchemaNode)((ListSchemaNode)childSchema));
            ReadDataTransactionUtil.buildMapEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)mapEntryBuilder, mapEntryNode, baseSchemaCtxTree, actualNode, trim, keys);
            builder.withChild(mapEntryBuilder.build());
        }
    }

    private static void buildCont(DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> builder, ContainerNode result, DataSchemaContextTree baseSchemaCtxTree, YangInstanceIdentifier actualPath, boolean trim) {
        for (DataContainerChild child : result.getValue()) {
            YangInstanceIdentifier path = actualPath.node(child.getIdentifier());
            DataSchemaNode childSchema = baseSchemaCtxTree.getChild(path).getDataSchemaNode();
            if (child instanceof ContainerNode) {
                DataContainerNodeAttrBuilder builderChild = Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)childSchema));
                ReadDataTransactionUtil.buildCont((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode>)builderChild, result, baseSchemaCtxTree, actualPath, trim);
                builder.withChild((DataContainerChild)builderChild.build());
                continue;
            }
            if (child instanceof MapNode) {
                CollectionNodeBuilder childBuilder = Builders.mapBuilder((ListSchemaNode)((ListSchemaNode)childSchema));
                ReadDataTransactionUtil.buildList((CollectionNodeBuilder<MapEntryNode, MapNode>)childBuilder, (MapNode)child, baseSchemaCtxTree, path, trim, ((ListSchemaNode)childSchema).getKeyDefinition());
                builder.withChild((DataContainerChild)childBuilder.build());
                continue;
            }
            if (!(child instanceof LeafNode)) continue;
            Object defaultVal = ((LeafSchemaNode)childSchema).getType().getDefaultValue().orElse(null);
            Object nodeVal = child.getValue();
            NormalizedNodeAttrBuilder leafBuilder = Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)childSchema));
            if (trim) {
                if (defaultVal != null && defaultVal.equals(nodeVal)) continue;
                leafBuilder.withValue(((LeafNode)child).getValue());
                builder.withChild((DataContainerChild)leafBuilder.build());
                continue;
            }
            if (defaultVal == null || !defaultVal.equals(nodeVal)) continue;
            leafBuilder.withValue(((LeafNode)child).getValue());
            builder.withChild((DataContainerChild)leafBuilder.build());
        }
    }

    @Nullable
    private static NormalizedNode<?, ?> readDataViaTransaction(@Nonnull TransactionVarsWrapper transactionNode) {
        NormalizedNodeFactory dataFactory = new NormalizedNodeFactory();
        try (DOMDataTreeReadTransaction tx = transactionNode.getTransactionChain().newReadOnlyTransaction();){
            FluentFuture listenableFuture = tx.read(transactionNode.getLogicalDatastoreType(), transactionNode.getInstanceIdentifier().getInstanceIdentifier());
            FutureCallbackTx.addCallback(listenableFuture, "READ", dataFactory);
        }
        return dataFactory.build();
    }

    @Nullable
    private static NormalizedNode<?, ?> readAllData(@Nonnull TransactionVarsWrapper transactionNode, String withDefa, SchemaContext ctx) {
        transactionNode.setLogicalDatastoreType(LogicalDatastoreType.OPERATIONAL);
        NormalizedNode<?, ?> stateDataNode = ReadDataTransactionUtil.readDataViaTransaction(transactionNode);
        transactionNode.setLogicalDatastoreType(LogicalDatastoreType.CONFIGURATION);
        NormalizedNode<?, ?> configDataNode = withDefa == null ? ReadDataTransactionUtil.readDataViaTransaction(transactionNode) : ReadDataTransactionUtil.prepareDataByParamWithDef(ReadDataTransactionUtil.readDataViaTransaction(transactionNode), transactionNode.getInstanceIdentifier().getInstanceIdentifier(), withDefa, ctx);
        if (stateDataNode == null && configDataNode == null) {
            return null;
        }
        if (stateDataNode == null) {
            return configDataNode;
        }
        if (configDataNode == null) {
            return stateDataNode;
        }
        return ReadDataTransactionUtil.mergeStateAndConfigData(stateDataNode, configDataNode);
    }

    @Nonnull
    private static NormalizedNode<?, ?> mergeStateAndConfigData(@Nonnull NormalizedNode<?, ?> stateDataNode, @Nonnull NormalizedNode<?, ?> configDataNode) {
        ReadDataTransactionUtil.validateNodeMerge(stateDataNode, configDataNode);
        if (configDataNode instanceof RpcDefinition) {
            return ReadDataTransactionUtil.prepareRpcData(configDataNode, stateDataNode);
        }
        return ReadDataTransactionUtil.prepareData(configDataNode, stateDataNode);
    }

    private static void validateNodeMerge(@Nonnull NormalizedNode<?, ?> stateDataNode, @Nonnull NormalizedNode<?, ?> configDataNode) {
        QNameModule moduleOfConfigData;
        QNameModule moduleOfStateData = stateDataNode.getIdentifier().getNodeType().getModule();
        if (!moduleOfStateData.equals((Object)(moduleOfConfigData = configDataNode.getIdentifier().getNodeType().getModule()))) {
            throw new RestconfDocumentedException("Unable to merge data from different modules.");
        }
    }

    @Nonnull
    private static NormalizedNode<?, ?> prepareRpcData(@Nonnull NormalizedNode<?, ?> configDataNode, @Nonnull NormalizedNode<?, ?> stateDataNode) {
        DataContainerNodeBuilder mapEntryBuilder = ImmutableNodes.mapEntryBuilder();
        mapEntryBuilder.withNodeIdentifier((YangInstanceIdentifier.PathArgument)((YangInstanceIdentifier.NodeIdentifierWithPredicates)configDataNode.getIdentifier()));
        ReadDataTransactionUtil.mapRpcDataNode(configDataNode, (DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)mapEntryBuilder);
        ReadDataTransactionUtil.mapRpcDataNode(stateDataNode, (DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)mapEntryBuilder);
        return ImmutableNodes.mapNodeBuilder((QName)configDataNode.getNodeType()).addChild(mapEntryBuilder.build()).build();
    }

    private static void mapRpcDataNode(@Nonnull NormalizedNode<?, ?> dataNode, @Nonnull DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder) {
        ((ContainerNode)dataNode).getValue().forEach(arg_0 -> mapEntryBuilder.addChild(arg_0));
    }

    @Nonnull
    private static NormalizedNode<?, ?> prepareData(@Nonnull NormalizedNode<?, ?> configDataNode, @Nonnull NormalizedNode<?, ?> stateDataNode) {
        if (configDataNode instanceof OrderedMapNode) {
            CollectionNodeBuilder builder = Builders.orderedMapBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((MapNode)configDataNode).getIdentifier());
            ReadDataTransactionUtil.mapValueToBuilder(((OrderedMapNode)configDataNode).getValue(), ((OrderedMapNode)stateDataNode).getValue(), builder);
            return builder.build();
        }
        if (configDataNode instanceof MapNode) {
            CollectionNodeBuilder builder = ImmutableNodes.mapNodeBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((MapNode)configDataNode).getIdentifier());
            ReadDataTransactionUtil.mapValueToBuilder(((MapNode)configDataNode).getValue(), ((MapNode)stateDataNode).getValue(), builder);
            return builder.build();
        }
        if (configDataNode instanceof MapEntryNode) {
            DataContainerNodeBuilder builder = ImmutableNodes.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((MapEntryNode)configDataNode).getIdentifier());
            ReadDataTransactionUtil.mapValueToBuilder(((MapEntryNode)configDataNode).getValue(), ((MapEntryNode)stateDataNode).getValue(), builder);
            return builder.build();
        }
        if (configDataNode instanceof ContainerNode) {
            DataContainerNodeAttrBuilder builder = Builders.containerBuilder().withNodeIdentifier(((ContainerNode)configDataNode).getIdentifier());
            ReadDataTransactionUtil.mapValueToBuilder(((ContainerNode)configDataNode).getValue(), ((ContainerNode)stateDataNode).getValue(), builder);
            return builder.build();
        }
        if (configDataNode instanceof AugmentationNode) {
            DataContainerNodeBuilder builder = Builders.augmentationBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((AugmentationNode)configDataNode).getIdentifier());
            ReadDataTransactionUtil.mapValueToBuilder(((AugmentationNode)configDataNode).getValue(), ((AugmentationNode)stateDataNode).getValue(), builder);
            return builder.build();
        }
        if (configDataNode instanceof ChoiceNode) {
            DataContainerNodeBuilder builder = Builders.choiceBuilder().withNodeIdentifier(((ChoiceNode)configDataNode).getIdentifier());
            ReadDataTransactionUtil.mapValueToBuilder(((ChoiceNode)configDataNode).getValue(), ((ChoiceNode)stateDataNode).getValue(), builder);
            return builder.build();
        }
        if (configDataNode instanceof LeafNode) {
            return ImmutableNodes.leafNode((QName)configDataNode.getNodeType(), (Object)configDataNode.getValue());
        }
        if (configDataNode instanceof OrderedLeafSetNode) {
            ListNodeBuilder builder = Builders.orderedLeafSetBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((OrderedLeafSetNode)configDataNode).getIdentifier());
            ReadDataTransactionUtil.mapValueToBuilder(((OrderedLeafSetNode)configDataNode).getValue(), ((OrderedLeafSetNode)stateDataNode).getValue(), builder);
            return builder.build();
        }
        if (configDataNode instanceof LeafSetNode) {
            ListNodeBuilder builder = Builders.leafSetBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((LeafSetNode)configDataNode).getIdentifier());
            ReadDataTransactionUtil.mapValueToBuilder(((LeafSetNode)configDataNode).getValue(), ((LeafSetNode)stateDataNode).getValue(), builder);
            return builder.build();
        }
        if (configDataNode instanceof UnkeyedListNode) {
            CollectionNodeBuilder builder = Builders.unkeyedListBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((UnkeyedListNode)configDataNode).getIdentifier());
            ReadDataTransactionUtil.mapValueToBuilder((Collection)((UnkeyedListNode)configDataNode).getValue(), (Collection)((UnkeyedListNode)stateDataNode).getValue(), builder);
            return builder.build();
        }
        if (configDataNode instanceof UnkeyedListEntryNode) {
            DataContainerNodeAttrBuilder builder = Builders.unkeyedListEntryBuilder().withNodeIdentifier(((UnkeyedListEntryNode)configDataNode).getIdentifier());
            ReadDataTransactionUtil.mapValueToBuilder(((UnkeyedListEntryNode)configDataNode).getValue(), ((UnkeyedListEntryNode)stateDataNode).getValue(), builder);
            return builder.build();
        }
        throw new RestconfDocumentedException("Unexpected node type: " + configDataNode.getClass().getName());
    }

    private static <T extends NormalizedNode<? extends YangInstanceIdentifier.PathArgument, ?>> void mapValueToBuilder(@Nonnull Collection<T> configData, @Nonnull Collection<T> stateData, @Nonnull NormalizedNodeContainerBuilder<?, YangInstanceIdentifier.PathArgument, T, ?> builder) {
        Map configMap = configData.stream().collect(Collectors.toMap(NormalizedNode::getIdentifier, Function.identity()));
        Map stateMap = stateData.stream().collect(Collectors.toMap(NormalizedNode::getIdentifier, Function.identity()));
        ReadDataTransactionUtil.mapDataToBuilder(configMap, stateMap, builder);
        ReadDataTransactionUtil.mergeDataToBuilder(configMap, stateMap, builder);
    }

    private static <T extends NormalizedNode<? extends YangInstanceIdentifier.PathArgument, ?>> void mapDataToBuilder(@Nonnull Map<YangInstanceIdentifier.PathArgument, T> configMap, @Nonnull Map<YangInstanceIdentifier.PathArgument, T> stateMap, @Nonnull NormalizedNodeContainerBuilder<?, YangInstanceIdentifier.PathArgument, T, ?> builder) {
        configMap.entrySet().stream().filter(x -> !stateMap.containsKey(x.getKey())).forEach(y -> builder.addChild((NormalizedNode)y.getValue()));
        stateMap.entrySet().stream().filter(x -> !configMap.containsKey(x.getKey())).forEach(y -> builder.addChild((NormalizedNode)y.getValue()));
    }

    private static <T extends NormalizedNode<? extends YangInstanceIdentifier.PathArgument, ?>> void mergeDataToBuilder(@Nonnull Map<YangInstanceIdentifier.PathArgument, T> configMap, @Nonnull Map<YangInstanceIdentifier.PathArgument, T> stateMap, @Nonnull NormalizedNodeContainerBuilder<?, YangInstanceIdentifier.PathArgument, T, ?> builder) {
        configMap.entrySet().stream().filter(x -> stateMap.containsKey(x.getKey())).forEach(y -> builder.addChild(ReadDataTransactionUtil.prepareData((NormalizedNode)y.getValue(), (NormalizedNode)stateMap.get(y.getKey()))));
    }
}

