/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.utils;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import javax.ws.rs.core.Response;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.nb.rfc8040.handlers.RpcServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.FutureCallbackTx;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.RpcResultFactory;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestconfInvokeOperationsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RestconfInvokeOperationsUtil.class);

    private RestconfInvokeOperationsUtil() {
        throw new UnsupportedOperationException("Util class");
    }

    public static DOMRpcResult invokeRpcViaMountPoint(DOMMountPoint mountPoint, NormalizedNode<?, ?> data, SchemaPath schemaPath) {
        Optional mountPointService = mountPoint.getService(DOMRpcService.class);
        if (mountPointService.isPresent()) {
            FluentFuture rpc = ((DOMRpcService)mountPointService.get()).invokeRpc(schemaPath, data);
            return RestconfInvokeOperationsUtil.prepareResult((FluentFuture<DOMRpcResult>)rpc);
        }
        String errmsg = "RPC service is missing.";
        LOG.debug("RPC service is missing.");
        throw new RestconfDocumentedException("RPC service is missing.");
    }

    public static DOMRpcResult invokeRpc(NormalizedNode<?, ?> data, SchemaPath schemaPath, RpcServiceHandler rpcServiceHandler) {
        DOMRpcService rpcService = rpcServiceHandler.get();
        if (rpcService == null) {
            throw new RestconfDocumentedException(Response.Status.SERVICE_UNAVAILABLE);
        }
        FluentFuture rpc = rpcService.invokeRpc(schemaPath, data);
        return RestconfInvokeOperationsUtil.prepareResult((FluentFuture<DOMRpcResult>)rpc);
    }

    public static DOMRpcResult checkResponse(DOMRpcResult response) {
        if (response == null) {
            return null;
        }
        try {
            if (response.getErrors().isEmpty()) {
                return response;
            }
            LOG.debug("RpcError message {}", (Object)response.getErrors());
            throw new RestconfDocumentedException("RPCerror message ", null, response.getErrors());
        }
        catch (CancellationException e) {
            String errMsg = "The operation was cancelled while executing.";
            LOG.debug("Cancel RpcExecution: {}", (Object)"The operation was cancelled while executing.", (Object)e);
            throw new RestconfDocumentedException("The operation was cancelled while executing.", RestconfError.ErrorType.RPC, RestconfError.ErrorTag.PARTIAL_OPERATION, (Throwable)e);
        }
    }

    private static DOMRpcResult prepareResult(FluentFuture<DOMRpcResult> rpc) {
        RpcResultFactory dataFactory = new RpcResultFactory();
        FutureCallbackTx.addCallback(rpc, "POST", dataFactory);
        return dataFactory.build();
    }
}

