/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.util.DataChangeScope;
import org.opendaylight.restconf.nb.rfc8040.Rfc8040;
import org.opendaylight.restconf.nb.rfc8040.handlers.NotificationServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.rests.services.impl.RestconfStreamsSubscriptionServiceImpl;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.ResolveEnumUtil;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.ListenerAdapter;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.NotificationListenerAdapter;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.Notificator;
import org.opendaylight.restconf.nb.rfc8040.streams.websockets.WebSocketServer;
import org.opendaylight.restconf.nb.rfc8040.utils.RestconfConstants;
import org.opendaylight.restconf.nb.rfc8040.utils.mapping.RestconfMappingNodeUtil;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.IdentifierCodec;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.sal.restconf.event.subscription.rev140708.NotificationOutputTypeGrouping;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SubscribeToStreamUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SubscribeToStreamUtil.class);
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).appendOffset("+HH:MM", "Z").toFormatter();

    private SubscribeToStreamUtil() {
        throw new UnsupportedOperationException("Util class");
    }

    public static URI notifYangStream(String identifier, UriInfo uriInfo, RestconfStreamsSubscriptionServiceImpl.NotificationQueryParams notificationQueryParams, RestconfStreamsSubscriptionServiceImpl.HandlersHolder handlersHolder) {
        String streamName = Notificator.createStreamNameFromUri(identifier);
        if (Strings.isNullOrEmpty((String)streamName)) {
            throw new RestconfDocumentedException("Stream name is empty.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        List<NotificationListenerAdapter> listeners = Notificator.getNotificationListenerFor(streamName);
        listeners = identifier.contains('/' + NotificationOutputTypeGrouping.NotificationOutputType.JSON.getName()) ? SubscribeToStreamUtil.pickSpecificListenerByOutput(listeners, NotificationOutputTypeGrouping.NotificationOutputType.JSON.getName()) : SubscribeToStreamUtil.pickSpecificListenerByOutput(listeners, NotificationOutputTypeGrouping.NotificationOutputType.XML.getName());
        if (listeners.isEmpty()) {
            throw new RestconfDocumentedException("Stream was not found.", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.UNKNOWN_ELEMENT);
        }
        DOMDataTreeReadWriteTransaction wTx = handlersHolder.getTransactionChainHandler().get().newReadWriteTransaction();
        SchemaContext schemaContext = handlersHolder.getSchemaHandler().get();
        boolean exist = SubscribeToStreamUtil.checkExist(schemaContext, (DOMDataTreeReadTransaction)wTx);
        URI uri = SubscribeToStreamUtil.prepareUriByStreamName(uriInfo, streamName);
        for (NotificationListenerAdapter listener : listeners) {
            SubscribeToStreamUtil.registerToListenNotification(listener, handlersHolder.getNotificationServiceHandler());
            listener.setQueryParams(notificationQueryParams.getStart(), (Optional)notificationQueryParams.getStop(), (Optional)notificationQueryParams.getFilter(), false);
            listener.setCloseVars(handlersHolder.getTransactionChainHandler(), handlersHolder.getSchemaHandler());
            NormalizedNode mapToStreams = RestconfMappingNodeUtil.mapYangNotificationStreamByIetfRestconfMonitoring(listener.getSchemaPath().getLastComponent(), schemaContext.getNotifications(), notificationQueryParams.getStart(), listener.getOutputType(), uri, SubscribeToStreamUtil.getMonitoringModule(schemaContext), exist);
            SubscribeToStreamUtil.writeDataToDS(schemaContext, listener.getSchemaPath().getLastComponent().getLocalName(), wTx, exist, mapToStreams);
        }
        SubscribeToStreamUtil.submitData(wTx);
        return uri;
    }

    static List<NotificationListenerAdapter> pickSpecificListenerByOutput(List<NotificationListenerAdapter> listeners, String outputType) {
        for (NotificationListenerAdapter notificationListenerAdapter : listeners) {
            if (!notificationListenerAdapter.getOutputType().equals(outputType)) continue;
            ArrayList<NotificationListenerAdapter> list = new ArrayList<NotificationListenerAdapter>();
            list.add(notificationListenerAdapter);
            return list;
        }
        return listeners;
    }

    public static InstanceIdentifierContext<?> prepareIIDSubsStreamOutput(SchemaContextHandler schemaHandler) {
        QName qnameBase = QName.create((String)"subscribe:to:notification", (String)"2016-10-28", (String)"notifi");
        DataSchemaNode location = ((ContainerSchemaNode)((Module)schemaHandler.get().findModule(qnameBase.getModule()).get()).getDataChildByName(qnameBase)).getDataChildByName(QName.create((QName)qnameBase, (String)"location"));
        ArrayList<YangInstanceIdentifier.NodeIdentifier> path = new ArrayList<YangInstanceIdentifier.NodeIdentifier>();
        path.add(YangInstanceIdentifier.NodeIdentifier.create((QName)qnameBase));
        path.add(YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QName)qnameBase, (String)"location")));
        return new InstanceIdentifierContext(YangInstanceIdentifier.create(path), (SchemaNode)location, null, schemaHandler.get());
    }

    public static URI notifiDataStream(String identifier, UriInfo uriInfo, RestconfStreamsSubscriptionServiceImpl.NotificationQueryParams notificationQueryParams, RestconfStreamsSubscriptionServiceImpl.HandlersHolder handlersHolder) {
        Map<String, String> mapOfValues = SubscribeToStreamUtil.mapValuesFromUri(identifier);
        LogicalDatastoreType ds = SubscribeToStreamUtil.parseURIEnum(LogicalDatastoreType.class, mapOfValues.get("datastore"));
        if (ds == null) {
            String msg = "Stream name doesn't contains datastore value (pattern /datastore=)";
            LOG.debug("Stream name doesn't contains datastore value (pattern /datastore=)");
            throw new RestconfDocumentedException("Stream name doesn't contains datastore value (pattern /datastore=)", RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.MISSING_ATTRIBUTE);
        }
        DataChangeScope scope = SubscribeToStreamUtil.parseURIEnum(DataChangeScope.class, mapOfValues.get("scope"));
        if (scope == null) {
            String msg = "Stream name doesn't contains datastore value (pattern /scope=)";
            LOG.warn("Stream name doesn't contains datastore value (pattern /scope=)");
            throw new RestconfDocumentedException("Stream name doesn't contains datastore value (pattern /scope=)", RestconfError.ErrorType.APPLICATION, RestconfError.ErrorTag.MISSING_ATTRIBUTE);
        }
        String streamName = Notificator.createStreamNameFromUri(identifier);
        ListenerAdapter listener = Notificator.getListenerFor(streamName);
        Preconditions.checkNotNull((Object)listener, (Object)("Listener doesn't exist : " + streamName));
        listener.setQueryParams(notificationQueryParams.getStart(), (Optional)notificationQueryParams.getStop(), (Optional)notificationQueryParams.getFilter(), false);
        listener.setCloseVars(handlersHolder.getTransactionChainHandler(), handlersHolder.getSchemaHandler());
        SubscribeToStreamUtil.registration(ds, scope, listener, handlersHolder.getDomDataBrokerHandler().get());
        URI uri = SubscribeToStreamUtil.prepareUriByStreamName(uriInfo, streamName);
        DOMDataTreeReadWriteTransaction wTx = handlersHolder.getTransactionChainHandler().get().newReadWriteTransaction();
        SchemaContext schemaContext = handlersHolder.getSchemaHandler().get();
        boolean exist = SubscribeToStreamUtil.checkExist(schemaContext, (DOMDataTreeReadTransaction)wTx);
        NormalizedNode mapToStreams = RestconfMappingNodeUtil.mapDataChangeNotificationStreamByIetfRestconfMonitoring(listener.getPath(), notificationQueryParams.getStart(), listener.getOutputType(), uri, SubscribeToStreamUtil.getMonitoringModule(schemaContext), exist, schemaContext);
        SubscribeToStreamUtil.writeDataToDS(schemaContext, listener.getPath().getLastPathArgument().getNodeType().getLocalName(), wTx, exist, mapToStreams);
        SubscribeToStreamUtil.submitData(wTx);
        return uri;
    }

    public static Module getMonitoringModule(SchemaContext schemaContext) {
        return schemaContext.findModule(Rfc8040.MonitoringModule.MODULE_QNAME).orElse(null);
    }

    public static Instant parseDateFromQueryParam(Map.Entry<String, List<String>> entry) {
        TemporalAccessor p;
        DateAndTime event = new DateAndTime(entry.getValue().iterator().next());
        String value = event.getValue();
        try {
            p = FORMATTER.parse(value);
        }
        catch (DateTimeParseException e) {
            throw new RestconfDocumentedException("Cannot parse of value in date: " + value, (Throwable)e);
        }
        return Instant.from(p);
    }

    static void writeDataToDS(SchemaContext schemaContext, String name, DOMDataTreeReadWriteTransaction readWriteTransaction, boolean exist, NormalizedNode mapToStreams) {
        String pathId = "";
        pathId = exist ? "ietf-restconf-monitoring:restconf-state/streams/stream=" + name : "ietf-restconf-monitoring:restconf-state/streams";
        readWriteTransaction.merge(LogicalDatastoreType.OPERATIONAL, IdentifierCodec.deserialize(pathId, schemaContext), mapToStreams);
    }

    static void submitData(DOMDataTreeReadWriteTransaction readWriteTransaction) {
        try {
            readWriteTransaction.commit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RestconfDocumentedException("Problem while putting data to DS.", (Throwable)e);
        }
    }

    public static Map<String, String> mapValuesFromUri(String identifier) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String token : RestconfConstants.SLASH_SPLITTER.split((CharSequence)identifier)) {
            String[] paramToken = token.split(String.valueOf('='));
            if (paramToken.length != 2) continue;
            result.put(paramToken[0], paramToken[1]);
        }
        return result;
    }

    static URI prepareUriByStreamName(UriInfo uriInfo, String streamName) {
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        SubscribeToStreamUtil.prepareNotificationPort(uriInfo.getBaseUri().getPort());
        uriBuilder.scheme("ws");
        return uriBuilder.replacePath(streamName).build(new Object[0]);
    }

    private static void registration(LogicalDatastoreType ds, DataChangeScope scope, ListenerAdapter listener, DOMDataBroker domDataBroker) {
        if (listener.isListening()) {
            return;
        }
        DOMDataTreeChangeService changeService = (DOMDataTreeChangeService)domDataBroker.getExtensions().getInstance(DOMDataTreeChangeService.class);
        if (changeService == null) {
            throw new UnsupportedOperationException("DOMDataBroker does not support the DOMDataTreeChangeService");
        }
        DOMDataTreeIdentifier root = new DOMDataTreeIdentifier(ds, listener.getPath());
        ListenerRegistration registration = changeService.registerDataTreeChangeListener(root, (DOMDataTreeChangeListener)listener);
        listener.setRegistration(registration);
    }

    private static void prepareNotificationPort(int port) {
        try {
            WebSocketServer.getInstance();
        }
        catch (NullPointerException e) {
            WebSocketServer.createInstance(port);
        }
    }

    static boolean checkExist(SchemaContext schemaContext, DOMDataTreeReadTransaction readWriteTransaction) {
        boolean exist;
        try {
            exist = (Boolean)readWriteTransaction.exists(LogicalDatastoreType.OPERATIONAL, IdentifierCodec.deserialize("ietf-restconf-monitoring:restconf-state/streams", schemaContext)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RestconfDocumentedException("Problem while checking data if exists", (Throwable)e);
        }
        return exist;
    }

    private static void registerToListenNotification(NotificationListenerAdapter listener, NotificationServiceHandler notificationServiceHandler) {
        if (listener.isListening()) {
            return;
        }
        SchemaPath path = listener.getSchemaPath();
        ListenerRegistration registration = notificationServiceHandler.get().registerNotificationListener((DOMNotificationListener)listener, new SchemaPath[]{path});
        listener.setRegistration(registration);
    }

    private static <T> T parseURIEnum(Class<T> clazz, String value) {
        if (value == null || value.equals("")) {
            return null;
        }
        return ResolveEnumUtil.resolveEnum(clazz, value);
    }
}

