/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.rests.utils;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import java.util.ArrayList;
import java.util.Iterator;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.nb.rfc8040.handlers.TransactionChainHandler;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.FutureCallbackTx;
import org.opendaylight.restconf.nb.rfc8040.rests.utils.FutureDataFactory;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionUtil.class);

    private TransactionUtil() {
        throw new UnsupportedOperationException("Util class");
    }

    public static void ensureParentsByMerge(YangInstanceIdentifier path, SchemaContext schemaContext, DOMDataTreeWriteTransaction writeTx) {
        ArrayList<YangInstanceIdentifier.PathArgument> normalizedPathWithoutChildArgs = new ArrayList<YangInstanceIdentifier.PathArgument>();
        YangInstanceIdentifier rootNormalizedPath = null;
        Iterator it = path.getPathArguments().iterator();
        while (it.hasNext()) {
            YangInstanceIdentifier.PathArgument pathArgument = (YangInstanceIdentifier.PathArgument)it.next();
            if (rootNormalizedPath == null) {
                rootNormalizedPath = YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{pathArgument});
            }
            if (!it.hasNext()) continue;
            normalizedPathWithoutChildArgs.add(pathArgument);
        }
        if (normalizedPathWithoutChildArgs.isEmpty()) {
            return;
        }
        Preconditions.checkArgument((rootNormalizedPath != null ? 1 : 0) != 0, (Object)"Empty path received");
        NormalizedNode parentStructure = ImmutableNodes.fromInstanceId((SchemaContext)schemaContext, (YangInstanceIdentifier)YangInstanceIdentifier.create(normalizedPathWithoutChildArgs));
        writeTx.merge(LogicalDatastoreType.CONFIGURATION, rootNormalizedPath, parentStructure);
    }

    public static void checkItemExists(TransactionChainHandler transactionChainHandler, DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType store, YangInstanceIdentifier path, String operationType) {
        FluentFuture future = rwTransaction.exists(store, path);
        FutureDataFactory response = new FutureDataFactory();
        FutureCallbackTx.addCallback(future, operationType, response);
        if (!((Boolean)response.result).booleanValue()) {
            rwTransaction.cancel();
            transactionChainHandler.reset();
            LOG.trace("Operation via Restconf was not executed because data at {} does not exist", (Object)path);
            throw new RestconfDocumentedException("Data does not exist", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.DATA_MISSING, path);
        }
    }

    public static void checkItemDoesNotExists(TransactionChainHandler transactionChainHandler, DOMDataTreeReadWriteTransaction rwTransaction, LogicalDatastoreType store, YangInstanceIdentifier path, String operationType) {
        FluentFuture future = rwTransaction.exists(store, path);
        FutureDataFactory response = new FutureDataFactory();
        FutureCallbackTx.addCallback(future, operationType, response);
        if (((Boolean)response.result).booleanValue()) {
            rwTransaction.cancel();
            transactionChainHandler.reset();
            LOG.trace("Operation via Restconf was not executed because data at {} already exists", (Object)path);
            throw new RestconfDocumentedException("Data already exists", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.DATA_EXISTS, path);
        }
    }
}

