/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.services.simple.impl;

import javax.ws.rs.Path;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.nb.rfc8040.Rfc8040;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.services.simple.api.RestconfService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

@Path(value="/")
public class RestconfImpl
implements RestconfService {
    private volatile SchemaContextHandler schemaContextHandler;

    public RestconfImpl(SchemaContextHandler schemaContextHandler) {
        this.schemaContextHandler = schemaContextHandler;
    }

    @Override
    public NormalizedNodeContext getLibraryVersion() {
        SchemaContext context = this.schemaContextHandler.get();
        DataSchemaNode schemaNode = null;
        for (GroupingDefinition groupingDefinition : ((Module)context.findModule(Rfc8040.RestconfModule.IETF_RESTCONF_QNAME.getModule()).get()).getGroupings()) {
            if (!groupingDefinition.getQName().equals((Object)Rfc8040.RestconfModule.RESTCONF_GROUPING_QNAME)) continue;
            schemaNode = ((ContainerSchemaNode)groupingDefinition.getDataChildByName(Rfc8040.RestconfModule.RESTCONF_CONTAINER_QNAME)).getDataChildByName(Rfc8040.RestconfModule.LIB_VER_LEAF_QNAME);
        }
        YangInstanceIdentifier yangIId = YangInstanceIdentifier.of((QName)QName.create((QName)Rfc8040.RestconfModule.IETF_RESTCONF_QNAME, (String)"yang-library-version"));
        InstanceIdentifierContext iid = new InstanceIdentifierContext(yangIId, schemaNode, null, context);
        NormalizedNode data = Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)schemaNode)).withValue((Object)Rfc8040.IetfYangLibrary.REVISION.toString()).build();
        return new NormalizedNodeContext(iid, data);
    }

    @Override
    public synchronized void updateHandlers(Object ... handlers) {
        for (Object object : handlers) {
            if (!(object instanceof SchemaContextHandler)) continue;
            this.schemaContextHandler = (SchemaContextHandler)object;
        }
    }
}

