/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.services.simple.impl;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMMountPointServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.references.SchemaContextRef;
import org.opendaylight.restconf.nb.rfc8040.services.simple.api.RestconfOperationsService;
import org.opendaylight.restconf.nb.rfc8040.services.simple.impl.FakeContainerSchemaNode;
import org.opendaylight.restconf.nb.rfc8040.services.simple.impl.FakeImportedModule;
import org.opendaylight.restconf.nb.rfc8040.services.simple.impl.FakeLeafSchemaNode;
import org.opendaylight.restconf.nb.rfc8040.services.simple.impl.FakeRestconfModule;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.ParserIdentifier;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.util.SimpleSchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class RestconfOperationsServiceImpl
implements RestconfOperationsService {
    private static final Logger LOG = LoggerFactory.getLogger(RestconfOperationsServiceImpl.class);
    private volatile SchemaContextHandler schemaContextHandler;
    private volatile DOMMountPointServiceHandler domMountPointServiceHandler;

    public RestconfOperationsServiceImpl(SchemaContextHandler schemaContextHandler, DOMMountPointServiceHandler domMountPointServiceHandler) {
        this.schemaContextHandler = schemaContextHandler;
        this.domMountPointServiceHandler = domMountPointServiceHandler;
    }

    @Override
    public synchronized void updateHandlers(Object ... handlers) {
        for (Object object : handlers) {
            if (object instanceof SchemaContextHandler) {
                this.schemaContextHandler = (SchemaContextHandler)object;
                continue;
            }
            if (!(object instanceof DOMMountPointServiceHandler)) continue;
            this.domMountPointServiceHandler = (DOMMountPointServiceHandler)object;
        }
    }

    @Override
    public NormalizedNodeContext getOperations(UriInfo uriInfo) {
        SchemaContextRef ref = new SchemaContextRef(this.schemaContextHandler.get());
        return RestconfOperationsServiceImpl.getOperations(ref.getModules(), null);
    }

    @Override
    public NormalizedNodeContext getOperations(String identifier, UriInfo uriInfo) {
        SchemaContextRef ref = new SchemaContextRef(this.schemaContextHandler.get());
        if (!identifier.contains("yang-ext:mount")) {
            String errMsg = "URI has bad format. If operations behind mount point should be showed, URI has to  end with yang-ext:mount";
            LOG.debug("{} for {}", (Object)"URI has bad format. If operations behind mount point should be showed, URI has to  end with yang-ext:mount", (Object)identifier);
            throw new RestconfDocumentedException("URI has bad format. If operations behind mount point should be showed, URI has to  end with yang-ext:mountyang-ext:mount", RestconfError.ErrorType.PROTOCOL, RestconfError.ErrorTag.INVALID_VALUE);
        }
        InstanceIdentifierContext<?> mountPointIdentifier = ParserIdentifier.toInstanceIdentifier(identifier, ref.get(), Optional.of(this.domMountPointServiceHandler.get()));
        DOMMountPoint mountPoint = mountPointIdentifier.getMountPoint();
        Set<Module> modules = ref.getModules(mountPoint);
        return RestconfOperationsServiceImpl.getOperations(modules, mountPoint);
    }

    private static NormalizedNodeContext getOperations(Set<Module> modules, DOMMountPoint mountPoint) {
        ArrayList<Module> neededModules = new ArrayList<Module>(modules.size());
        ArrayList<LeafSchemaNode> fakeRpcSchema = new ArrayList<LeafSchemaNode>();
        for (Module m : modules) {
            Set rpcs = m.getRpcs();
            if (rpcs.isEmpty()) continue;
            neededModules.add(m);
            fakeRpcSchema.ensureCapacity(fakeRpcSchema.size() + rpcs.size());
            rpcs.forEach(rpc -> fakeRpcSchema.add(new FakeLeafSchemaNode(rpc.getQName())));
        }
        FakeContainerSchemaNode fakeCont = new FakeContainerSchemaNode(fakeRpcSchema);
        DataContainerNodeAttrBuilder containerBuilder = Builders.containerBuilder((ContainerSchemaNode)fakeCont);
        for (LeafSchemaNode leaf : fakeRpcSchema) {
            containerBuilder.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)leaf).withValue((Object)Empty.getInstance()).build());
        }
        ArrayList<FakeRestconfModule> fakeModules = new ArrayList<FakeRestconfModule>(neededModules.size() + 1);
        neededModules.forEach(imp -> fakeModules.add((FakeRestconfModule)((Object)new FakeImportedModule((Module)imp))));
        fakeModules.add(new FakeRestconfModule(neededModules, fakeCont));
        SimpleSchemaContext fakeSchemaCtx = SimpleSchemaContext.forModules((Set)ImmutableSet.copyOf(fakeModules));
        InstanceIdentifierContext instanceIdentifierContext = new InstanceIdentifierContext(null, (SchemaNode)fakeCont, mountPoint, (SchemaContext)fakeSchemaCtx);
        return new NormalizedNodeContext(instanceIdentifierContext, containerBuilder.build());
    }
}

