/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.services.simple.impl;

import javax.ws.rs.Path;
import org.opendaylight.mdsal.dom.api.DOMYangTextSourceProvider;
import org.opendaylight.restconf.common.schema.SchemaExportContext;
import org.opendaylight.restconf.nb.rfc8040.handlers.DOMMountPointServiceHandler;
import org.opendaylight.restconf.nb.rfc8040.handlers.SchemaContextHandler;
import org.opendaylight.restconf.nb.rfc8040.references.SchemaContextRef;
import org.opendaylight.restconf.nb.rfc8040.services.simple.api.RestconfSchemaService;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.ParserIdentifier;

@Path(value="/")
public class RestconfSchemaServiceImpl
implements RestconfSchemaService {
    private volatile SchemaContextHandler schemaContextHandler;
    private volatile DOMMountPointServiceHandler domMountPointServiceHandler;
    private volatile DOMYangTextSourceProvider sourceProvider;

    public RestconfSchemaServiceImpl(SchemaContextHandler schemaContextHandler, DOMMountPointServiceHandler domMountPointServiceHandler, DOMYangTextSourceProvider sourceProvider) {
        this.schemaContextHandler = schemaContextHandler;
        this.domMountPointServiceHandler = domMountPointServiceHandler;
        this.sourceProvider = sourceProvider;
    }

    @Override
    public SchemaExportContext getSchema(String identifier) {
        SchemaContextRef schemaContextRef = new SchemaContextRef(this.schemaContextHandler.get());
        return ParserIdentifier.toSchemaExportContextFromIdentifier(schemaContextRef.get(), identifier, this.domMountPointServiceHandler.get(), this.sourceProvider);
    }

    @Override
    public synchronized void updateHandlers(Object ... handlers) {
        for (Object object : handlers) {
            if (object instanceof SchemaContextHandler) {
                this.schemaContextHandler = (SchemaContextHandler)object;
                continue;
            }
            if (object instanceof DOMMountPointServiceHandler) {
                this.domMountPointServiceHandler = (DOMMountPointServiceHandler)object;
                continue;
            }
            if (!(object instanceof DOMYangTextSourceProvider)) continue;
            this.sourceProvider = (DOMYangTextSourceProvider)object;
        }
    }
}

