/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.streams.listeners;

import com.google.common.eventbus.Subscribe;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.BaseListenerInterface;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.Event;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.EventType;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.Notificator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventBusChangeRecorder<T extends BaseListenerInterface> {
    private static final Logger LOG = LoggerFactory.getLogger(EventBusChangeRecorder.class);
    private final T listener;

    EventBusChangeRecorder(T listener) {
        this.listener = listener;
    }

    @Subscribe
    public void recordCustomerChange(Event event) {
        if (event.getType() == EventType.REGISTER) {
            Channel subscriber = event.getSubscriber();
            if (!this.listener.getSubscribers().contains(subscriber)) {
                this.listener.getSubscribers().add(subscriber);
            }
        } else if (event.getType() == EventType.DEREGISTER) {
            this.listener.getSubscribers().remove(event.getSubscriber());
            Notificator.removeListenerIfNoSubscriberExists(this.listener);
        } else if (event.getType() == EventType.NOTIFY) {
            for (Channel subscriber : this.listener.getSubscribers()) {
                if (subscriber.isActive()) {
                    LOG.debug("Data are sent to subscriber {}:", (Object)subscriber.remoteAddress());
                    subscriber.writeAndFlush((Object)new TextWebSocketFrame(event.getData()));
                    continue;
                }
                LOG.debug("Subscriber {} is removed - channel is not active yet.", (Object)subscriber.remoteAddress());
                this.listener.getSubscribers().remove(subscriber);
            }
        }
    }
}

